/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.termtrees;

import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;

public class NodeTerm
extends Term {
    String m_sFunctor;
    Term[] m_aTerms;

    public NodeTerm(String sFunctor) {
        this(sFunctor, new Term[0]);
    }

    public NodeTerm(String sFunctor, Term t1) {
        this(sFunctor, new Term[]{t1});
    }

    public NodeTerm(String sFunctor, Term t1, Term t2) {
        this(sFunctor, new Term[]{t1, t2});
    }

    public NodeTerm(String sFunctor, Term t1, Term t2, Term t3) {
        this(sFunctor, new Term[]{t1, t2, t3});
    }

    public NodeTerm(String sFunctor, Term t1, Term t2, Term t3, Term t4) {
        this(sFunctor, new Term[]{t1, t2, t3, t4});
    }

    public NodeTerm(String sFunctor, Term t1, Term t2, Term t3, Term t4, Term t5) {
        this(sFunctor, new Term[]{t1, t2, t3, t4, t5});
    }

    public NodeTerm(String sFunctor, Term[] aTerms) {
        this.m_sFunctor = sFunctor;
        this.m_aTerms = aTerms;
    }

    public NodeTerm(String sFunctor, Term term, Term[] aTerms) {
        this.m_sFunctor = sFunctor;
        this.m_aTerms = new Term[aTerms.length + 1];
        this.m_aTerms[0] = term;
        int c = this.m_aTerms.length;
        for (int i = 1; i < c; ++i) {
            this.m_aTerms[i] = aTerms[i - 1];
        }
    }

    public NodeTerm(String sFunctor, Term[] aTerms, Term term) {
        int c = aTerms.length;
        this.m_sFunctor = sFunctor;
        this.m_aTerms = new Term[aTerms.length + 1];
        this.m_aTerms[aTerms.length] = term;
        for (int i = 0; i < c; ++i) {
            this.m_aTerms[i] = aTerms[i];
        }
    }

    @Override
    public String getFunctor() {
        return this.m_sFunctor;
    }

    @Override
    public boolean isLeaf() {
        return this.m_aTerms.length > 0;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public Term[] children() {
        return this.m_aTerms;
    }

    @Override
    public int length() {
        return this.m_aTerms.length;
    }

    @Override
    public Term termAt(int index) {
        if (index == 0) {
            return AtomicTerm.createSymbol(this.getFunctor());
        }
        return this.m_aTerms[index - 1];
    }

    @Override
    public Term withChild(Term t) {
        Term[] temp = new Term[this.m_aTerms.length + 1];
        for (Term temp[i] : this.m_aTerms) {
        }
        temp[this.m_aTerms.length] = t;
        this.m_aTerms = temp;
        return this;
    }

    @Override
    public boolean termEqual(Term t) {
        if (t == null) {
            return false;
        }
        if (t.isAtom()) {
            return false;
        }
        NodeTerm nt = (NodeTerm)t;
        if (!this.m_sFunctor.equals(nt.m_sFunctor)) {
            return false;
        }
        int count = this.m_aTerms.length;
        Term[] aMyTerms = this.m_aTerms;
        Term[] aOtherTerms = nt.m_aTerms;
        if (count != aOtherTerms.length) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (aMyTerms[i].termEqual(aOtherTerms[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String fullFormString() {
        StringBuffer ans = new StringBuffer();
        ans.append(this.m_sFunctor);
        ans.append("(");
        int c = this.m_aTerms.length;
        for (int i = 0; i < c; ++i) {
            ans.append(this.m_aTerms[i].fullFormString());
            if (i == this.m_aTerms.length - 1) continue;
            ans.append(", ");
        }
        ans.append(")");
        return ans.toString();
    }

    @Override
    public void accept(TermWalker walker) {
        walker.acceptNode(this.getFunctor(), this);
    }

    public String toString() {
        StringBuffer ans = new StringBuffer();
        if (this.m_sFunctor.equals(".attr.")) {
            Term t = this.m_aTerms[0];
            ans.append(t.getFunctor());
            ans.append(":");
            ans.append(t.termAt(1).toString());
            return ans.toString();
        }
        if (this.m_sFunctor.equals(".pair.")) {
            Term t = this.m_aTerms[0];
            Term t2 = this.m_aTerms[1];
            ans.append(t.toString());
            ans.append(":");
            ans.append(t2.toString());
            return ans.toString();
        }
        if (!this.m_sFunctor.equals(".bag") && this.length() == 1 && this.m_aTerms[0].getFunctor().equals(".bag.")) {
            ans.append(this.m_sFunctor);
            ans.append(this.m_aTerms[0].toString());
            return ans.toString();
        }
        if (this.m_sFunctor.equals(".sequence.")) {
            for (int i = 0; i < this.m_aTerms.length; ++i) {
                ans.append(this.m_aTerms[i].toString());
                if (i == this.m_aTerms.length - 1) continue;
                ans.append("; ");
            }
            return ans.toString();
        }
        if (this.m_sFunctor.equals(".list.")) {
            ans.append("[");
        } else if (this.m_sFunctor.equals(".bag.")) {
            ans.append("{");
        } else {
            ans.append(this.m_sFunctor);
            ans.append("(");
        }
        for (int i = 0; i < this.m_aTerms.length; ++i) {
            ans.append(this.m_aTerms[i].toString());
            if (i == this.m_aTerms.length - 1) continue;
            ans.append(", ");
        }
        if (this.m_sFunctor.equals(".list.")) {
            ans.append("]");
        } else if (this.m_sFunctor.equals(".bag.")) {
            ans.append("}");
        } else {
            ans.append(")");
        }
        return ans.toString();
    }

    public void setFunctor(String sFunctor) {
        this.m_sFunctor = sFunctor;
    }
}

