/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.token;

import com.tangosol.coherence.dslquery.token.SQLDeleteOPToken;
import com.tangosol.coherence.dslquery.token.SQLOPToken;
import com.tangosol.coherence.dslquery.token.SQLSelectOPToken;
import com.tangosol.coherence.dslquery.token.SQLUpdateOPToken;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;

public class SQLExplainOPToken
extends SQLOPToken {
    private static final SQLSelectOPToken SQL_SELECT_OP_TOKEN = new SQLSelectOPToken("select");
    private static final SQLUpdateOPToken SQL_UPDATE_OP_TOKEN = new SQLUpdateOPToken("update");
    private static final SQLDeleteOPToken SQL_DELETE_OP_TOKEN = new SQLDeleteOPToken("delete");
    public static final String FUNCTOR = "sqlExplainNode";

    public SQLExplainOPToken(String id) {
        super(id, OPToken.IDENTIFIER_NODE);
    }

    @Override
    public Term nud(OPParser parser) {
        Term stmt;
        char cCurrent;
        OPScanner s = parser.getScanner();
        String sCurrent = s.getCurrentAsString();
        if (sCurrent == null) {
            return super.nud(parser);
        }
        if (sCurrent.length() == 1 && ((cCurrent = sCurrent.charAt(0)) == '.' || cCurrent == ',' || cCurrent == '(' || cCurrent == ';')) {
            return super.nud(parser);
        }
        this.advanceToStmt(s);
        if (s.advanceWhenMatching("select")) {
            SQLSelectOPToken token = SQL_SELECT_OP_TOKEN;
            stmt = token.nud(parser);
        } else if (s.advanceWhenMatching("update")) {
            SQLUpdateOPToken token = SQL_UPDATE_OP_TOKEN;
            stmt = token.nud(parser);
        } else if (s.advanceWhenMatching("delete")) {
            SQLDeleteOPToken token = SQL_DELETE_OP_TOKEN;
            stmt = token.nud(parser);
        } else {
            return super.nud(parser);
        }
        return new NodeTerm(this.getFunctor(), new Term[]{stmt});
    }

    protected void advanceToStmt(OPScanner s) {
        s.advance("plan");
        s.advance("for");
    }

    protected String getFunctor() {
        return FUNCTOR;
    }
}

