/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.oracle.coherence.persistence.OfflinePersistenceInfo;
import com.oracle.coherence.persistence.PersistenceStatistics;
import com.oracle.coherence.persistence.PersistenceTools;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.FormattedMapStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.persistence.CachePersistenceHelper;
import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValidateSnapshotStatementBuilder
extends AbstractStatementBuilder<ValidateSnapshotStatement> {
    public static final ValidateSnapshotStatementBuilder INSTANCE = new ValidateSnapshotStatementBuilder();

    @Override
    public ValidateSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sSnapshotDir = ValidateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotdirectory"));
        String sSnapshotName = ValidateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        String sServiceName = ValidateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("servicename"));
        boolean fVerbose = "true".equals(ValidateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("verbose")));
        boolean fArchived = "archived".equals(ValidateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("type")));
        return new ValidateSnapshotStatement(sSnapshotDir, fVerbose, fArchived, sSnapshotName, sServiceName);
    }

    @Override
    public String getSyntax() {
        return "VALIDATE SNAPSHOT 'snapshot-directory' [VERBOSE]\nVALIDATE SNAPSHOT 'snapshot-name' 'service-name' [VERBOSE]\nVALIDATE ARCHIVED SNAPSHOT 'snapshot-name' 'service-name' [VERBOSE]";
    }

    @Override
    public String getDescription() {
        return "Validate a snapshot (or archived snapshot) to ensure contents are valid.\nFor snapshots, either a directory location can be specified or a snapshot\nname and service name. When a directory name is not supplied, the\nsnapshot directory information is retrieved via the operational configuration.\nVerbose mode provides more detailed information regarding the contents of the\nsnapshot at the cost of increased execution time and resouce usage.\nNote: the relevant operational and cache configuration pertaining\nto the cluster and services to be valdiated must be available to be loaded.";
    }

    public static class ValidateSnapshotStatement
    extends AbstractStatement {
        private String m_sSnapshotDir;
        private final boolean f_fVerbose;
        private final boolean f_Archived;
        private final String f_sSnapshotName;
        private final String f_sServiceName;

        public ValidateSnapshotStatement(String sSnapshotDir, boolean fVerbose, boolean fArchived, String sSnapshotName, String sServiceName) {
            this.m_sSnapshotDir = sSnapshotDir;
            this.f_fVerbose = fVerbose;
            this.f_Archived = fArchived;
            this.f_sSnapshotName = AbstractSnapshotStatement.replaceDateMacros(sSnapshotName);
            this.f_sServiceName = sServiceName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public StatementResult execute(ExecutionContext ctx) {
            Object oResult = null;
            PrintWriter out = ctx.getWriter();
            ConfigurableCacheFactory ccf = ctx.getCacheFactory();
            try {
                PersistenceTools tools = null;
                if (this.f_Archived) {
                    out.println("Validating archived snapshot " + this.f_sSnapshotName);
                    out.flush();
                    if (!(ccf instanceof ExtensibleConfigurableCacheFactory)) throw new UnsupportedOperationException("ConfigurableCacheFactory is not an instance of ExtensibleConfigurableCacheFactory");
                    tools = CachePersistenceHelper.getArchiverPersistenceTools((ExtensibleConfigurableCacheFactory)ccf, this.f_sSnapshotName, this.f_sServiceName);
                } else {
                    File fileSnapshot = null;
                    if (this.m_sSnapshotDir == null || this.m_sSnapshotDir.isEmpty()) {
                        if (this.f_sSnapshotName == null || this.f_sSnapshotName.isEmpty() || this.f_sServiceName == null || this.f_sServiceName.isEmpty()) {
                            throw new CohQLException("You must specify either a directory or snapshot and service names.");
                        }
                        fileSnapshot = PersistenceToolsHelper.getSnapshotDirectory(ccf, this.f_sSnapshotName, this.f_sServiceName);
                        this.m_sSnapshotDir = fileSnapshot.getAbsolutePath();
                    } else {
                        fileSnapshot = new File(this.m_sSnapshotDir);
                    }
                    if (!(fileSnapshot.exists() && fileSnapshot.isDirectory() && fileSnapshot.canExecute())) {
                        throw new CohQLException("The directory '" + this.m_sSnapshotDir + "' does not exist or is not readable");
                    }
                    out.println("Validating snapshot directory '" + this.m_sSnapshotDir + "'");
                    out.flush();
                    tools = CachePersistenceHelper.getSnapshotPersistenceTools(fileSnapshot);
                }
                tools.validate();
                if (this.f_fVerbose) {
                    PersistenceStatistics stats = tools.getStatistics();
                    OfflinePersistenceInfo info = tools.getPersistenceInfo();
                    LinkedHashMap<String, Object> mapResults = new LinkedHashMap<String, Object>();
                    mapResults.put("Partition Count", String.valueOf(info.getPartitionCount()));
                    if (this.f_Archived) {
                        mapResults.put("Archived Snapshot", "Name=" + this.f_sSnapshotName + ", Service=" + this.f_sServiceName);
                        mapResults.put("Original Storage Format", info.getStorageFormat());
                    } else {
                        mapResults.put("Directory", this.m_sSnapshotDir);
                        mapResults.put("Storage Format", info.getStorageFormat());
                    }
                    mapResults.put("Storage Version", String.valueOf(info.getStorageVersion()));
                    mapResults.put("Implementation Version", String.valueOf(info.getImplVersion()));
                    mapResults.put("Number of Partitions Present", String.valueOf(info.getGUIDs().length));
                    mapResults.put("Is Complete?", String.valueOf(info.isComplete()));
                    mapResults.put("Is Archived Snapshot?", String.valueOf(info.isArchived()));
                    mapResults.put("Persistence Version", String.valueOf(info.getPersistenceVersion()));
                    mapResults.put("Statistics", "");
                    if (stats != null) {
                        for (String sCacheName : stats) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Size=" + stats.getCacheSize(sCacheName));
                            sb.append(", Bytes=" + stats.getCacheBytes(sCacheName));
                            sb.append(", Indexes=" + stats.getIndexCount(sCacheName));
                            sb.append(", Triggers=" + stats.getTriggerCount(sCacheName));
                            sb.append(", Listeners=" + stats.getListenerCount(sCacheName));
                            sb.append(", Locks=" + stats.getLockCount(sCacheName));
                            mapResults.put(sCacheName, sb.toString());
                        }
                    }
                    oResult = mapResults;
                } else {
                    oResult = "Success";
                }
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in VALIDATE SNAPSHOT:");
            }
            FormattedMapStatementResult result = new FormattedMapStatementResult(oResult);
            if (!(oResult instanceof Map)) return result;
            result.setColumnHeaders(new String[]{"Attribute", "Value"});
            return result;
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

