/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class RecoverSnapshotStatementBuilder
extends AbstractStatementBuilder<RecoverSnapshotStatement> {
    public static final RecoverSnapshotStatementBuilder INSTANCE = new RecoverSnapshotStatementBuilder();

    @Override
    public RecoverSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = RecoverSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        String sSnapshotName = RecoverSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        if (sSnapshotName == null || sSnapshotName.isEmpty()) {
            throw new CohQLException("Snapshot name required for recover snapshot");
        }
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for recover snapshot");
        }
        return new RecoverSnapshotStatement(sSnapshotName, sServiceName == null || sServiceName.isEmpty() ? null : sServiceName);
    }

    @Override
    public String getSyntax() {
        return "RECOVER SNAPSHOT 'snapshot-name' 'service'";
    }

    @Override
    public String getDescription() {
        return "Recover a snapshot for an individual service.";
    }

    public static class RecoverSnapshotStatement
    extends AbstractSnapshotStatement {
        public RecoverSnapshotStatement(String sSnapshotName, String sServiceName) {
            super(RecoverSnapshotStatement.replaceDateMacros(sSnapshotName), sServiceName);
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return this.getConfirmationMessage("recover");
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                this.validateServiceExists(helper);
                this.validateSnapshotExistsForService(helper);
                helper.ensureReady(ctx, this.f_sServiceName);
                out.println("Recovering snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                out.flush();
                helper.invokeOperationWithWait("recoverSnapshot", this.f_sSnapshotName, this.f_sServiceName);
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in RECOVER SNAPSHOT");
            }
            return new DefaultStatementResult("Success", true);
        }
    }
}

