/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class ListSnapshotsStatementBuilder
extends AbstractStatementBuilder<ListSnapshotsStatement> {
    public static final ListSnapshotsStatementBuilder INSTANCE = new ListSnapshotsStatementBuilder();

    @Override
    public ListSnapshotsStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sService = ListSnapshotsStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        boolean fArchived = "true".equals(ListSnapshotsStatementBuilder.atomicStringValueOf(term.findAttribute("archived")));
        return new ListSnapshotsStatement(sService, fArchived);
    }

    @Override
    public String getSyntax() {
        return "LIST [ARCHIVED] SNAPSHOTS ['service']";
    }

    @Override
    public String getDescription() {
        return "List snapshots for an individual service or all services. If ARCHIVED keyword\nis included then the archived snapshots for the service is listed. If there is\nno archiver defined for the service, then an exception will be raised.";
    }

    public static class ListSnapshotsStatement
    extends AbstractStatement {
        private final String f_sService;
        private final boolean f_fArchived;

        public ListSnapshotsStatement(String sService, boolean fArchived) {
            this.f_sService = sService;
            this.f_fArchived = fArchived;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            String[] oResult = null;
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            try {
                if (this.f_sService == null) {
                    oResult = this.f_fArchived ? helper.listArchivedSnapshots() : helper.listSnapshots();
                } else {
                    Map<String, String[]> mapServices = helper.listServices();
                    if (!mapServices.containsKey(this.f_sService)) {
                        throw new CohQLException("Service '" + this.f_sService + "' does not exist");
                    }
                    oResult = this.f_fArchived ? helper.listArchivedSnapshots(this.f_sService) : helper.listSnapshots(this.f_sService);
                }
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in LIST SNAPSHOTS");
            }
            return new DefaultStatementResult(oResult, true);
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

