/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.FormattedMapStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class ListServicesStatementBuilder
extends AbstractStatementBuilder<ListServicesStatement> {
    public static final ListServicesStatementBuilder INSTANCE = new ListServicesStatementBuilder();

    @Override
    public ListServicesStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        return new ListServicesStatement("true".equals(ListServicesStatementBuilder.atomicStringValueOf(term.findAttribute("environment"))));
    }

    @Override
    public String getSyntax() {
        return "LIST SERVICES [ENVIRONMENT]";
    }

    @Override
    public String getDescription() {
        return "List services and their persistence mode, quorum status and current\noperation status. If you specify ENVIRONMENT then the persistence environment\ndetails are displayed.";
    }

    public static class ListServicesStatement
    extends AbstractStatement {
        private final boolean f_fEnvironment;

        public ListServicesStatement(boolean fEnvironment) {
            this.f_fEnvironment = fEnvironment;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            DefaultStatementResult result;
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            try {
                if (this.f_fEnvironment) {
                    result = new DefaultStatementResult(helper.listServicesEnvironment());
                } else {
                    Map<String, String[]> mapServices = helper.listServices();
                    result = new FormattedMapStatementResult(mapServices);
                    ((FormattedMapStatementResult)result).setColumnHeaders(new String[]{"Service Name", "Mode", "Quorum Policy", "Current Operation"});
                }
            }
            catch (Exception e) {
                throw new CohQLException("Error in LIST SERVICES: " + e.getMessage());
            }
            return result;
        }

        @Override
        public void showPlan(PrintWriter out) {
        }
    }
}

