/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class CreateSnapshotStatementBuilder
extends AbstractStatementBuilder<CreateSnapshotStatement> {
    public static final CreateSnapshotStatementBuilder INSTANCE = new CreateSnapshotStatementBuilder();

    @Override
    public CreateSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = CreateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        String sSnapshotName = CreateSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        if (sSnapshotName == null || sSnapshotName.isEmpty()) {
            throw new CohQLException("Snapshot name required for create snapshot");
        }
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for create snapshot");
        }
        return new CreateSnapshotStatement(sSnapshotName, sServiceName);
    }

    @Override
    public String getSyntax() {
        return "CREATE SNAPSHOT 'snapshot-name' 'service'";
    }

    @Override
    public String getDescription() {
        return "Create a snapshot of cache contents for an individual service.\nIf you do not specify a service, then all services configured for either\non-demand or active mode will be included in snapshot. You can supply the\nfollowing to timestamp the snapshot:\n%y - Year, %m - Month, %d - Day, %hh - Hour, %mm - Minute, %w - weekday,\n%M - Month name";
    }

    public static class CreateSnapshotStatement
    extends AbstractSnapshotStatement {
        public CreateSnapshotStatement(String sSnapshotName, String sServiceName) {
            super(CreateSnapshotStatement.replaceDateMacros(sSnapshotName), sServiceName);
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return this.getConfirmationMessage("create");
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                this.validateSnapshotName(this.f_sSnapshotName);
                this.validateServiceExists(helper);
                String sErrorMsg = null;
                for (int i = 25; i > 0 && helper.snapshotExists(this.f_sServiceName, this.f_sSnapshotName); --i) {
                    if (sErrorMsg == null) {
                        sErrorMsg = "A snapshot named '" + this.f_sSnapshotName + "' already exists for service '" + this.f_sServiceName + "'";
                    }
                    Logger.warn(sErrorMsg + ": " + String.valueOf(helper.listSnapshots()));
                    Blocking.sleep(250L);
                }
                if (sErrorMsg != null) {
                    throw new CohQLException(sErrorMsg);
                }
                helper.ensureReady(ctx, this.f_sServiceName);
                out.println("Creating snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                out.flush();
                helper.invokeOperationWithWait("createSnapshot", this.f_sSnapshotName, this.f_sServiceName);
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in CREATE SNAPSHOT");
            }
            return new DefaultStatementResult("Success", true);
        }
    }
}

