/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement.persistence;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dslquery.statement.persistence.AbstractSnapshotStatement;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.List;

public class ArchiveSnapshotStatementBuilder
extends AbstractStatementBuilder<ArchiveSnapshotStatement> {
    public static final ArchiveSnapshotStatementBuilder INSTANCE = new ArchiveSnapshotStatementBuilder();

    @Override
    public ArchiveSnapshotStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sServiceName = ArchiveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("service"));
        String sSnapshotName = ArchiveSnapshotStatementBuilder.atomicStringValueOf(term.findAttribute("snapshotname"));
        if (sSnapshotName == null || sSnapshotName.isEmpty()) {
            throw new CohQLException("Snapshot name required for archive snapshot");
        }
        if (sServiceName == null || sServiceName.isEmpty()) {
            throw new CohQLException("Service name required for archive snapshot");
        }
        return new ArchiveSnapshotStatement(sSnapshotName, sServiceName);
    }

    @Override
    public String getSyntax() {
        return "ARCHIVE SNAPSHOT 'snapshot-name' 'service'";
    }

    @Override
    public String getDescription() {
        return "Archive a snapshot for an individual service to a centralized location using\nthe archiver configured for the service.";
    }

    public static class ArchiveSnapshotStatement
    extends AbstractSnapshotStatement {
        public ArchiveSnapshotStatement(String sSnapshotName, String sServiceName) {
            super(ArchiveSnapshotStatement.replaceDateMacros(sSnapshotName), sServiceName);
        }

        @Override
        public String getExecutionConfirmation(ExecutionContext ctx) {
            return this.getConfirmationMessage("archive");
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PersistenceToolsHelper helper = PersistenceToolsHelper.ensurePersistenceToolsHelper(ctx);
            PrintWriter out = ctx.getWriter();
            try {
                this.validateServiceExists(helper);
                this.validateSnapshotExistsForService(helper);
                this.validateSnapshotName(this.f_sSnapshotName);
                if (helper.archivedSnapshotExists(this.f_sServiceName, this.f_sSnapshotName)) {
                    throw new CohQLException("Archived snapshot '" + this.f_sSnapshotName + "' already exists for service '" + this.f_sServiceName + "'");
                }
                helper.ensureReady(ctx, this.f_sServiceName);
                out.println("Archiving snapshot '" + this.f_sSnapshotName + "' for service '" + this.f_sServiceName + "'");
                out.flush();
                helper.invokeOperationWithWait("archiveSnapshot", this.f_sSnapshotName, this.f_sServiceName);
            }
            catch (Exception e) {
                throw PersistenceToolsHelper.ensureCohQLException(e, "Error in ARCHIVE SNAPSHOT");
            }
            return new DefaultStatementResult("Success", true);
        }
    }
}

