/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.UpdateSetListMaker;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class UpdateStatementBuilder
extends AbstractStatementBuilder<UpdateStatement> {
    public static final UpdateStatementBuilder INSTANCE = new UpdateStatementBuilder();

    @Override
    public UpdateStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = UpdateStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for update command");
        }
        String sAlias = UpdateStatementBuilder.getAlias(term);
        Term termSetList = UpdateStatementBuilder.getSetList(term);
        NodeTerm termWhere = UpdateStatementBuilder.getWhere(term);
        Filter filter = UpdateStatementBuilder.ensureFilter(termWhere, sCacheName, sAlias, listBindVars, namedBindVars, ctx);
        UpdateSetListMaker transformer = this.createUpdateSetListMaker(ctx, listBindVars, namedBindVars);
        transformer.setAlias(sAlias);
        try {
            InvocableMap.EntryProcessor processor = transformer.makeSetList((NodeTerm)termSetList);
            return new UpdateStatement(sCacheName, filter, processor);
        }
        catch (Exception e) {
            throw new CohQLException("Error creating update processor", e);
        }
    }

    @Override
    public String getSyntax() {
        return "UPDATE 'cache-name' [[AS] alias] SET update-statement {, update-statement}*\n        [WHERE conditional-expression]";
    }

    @Override
    public String getDescription() {
        return "Update the cache named 'cache-name that are selected by the given conditional\nexpression. If no conditional-expression is given all entries will be updated!\nUse with Care! Assignment of both simple values and java constructors and\nstatic methods are supported. Simple addition and multiplication is supported as\nwell. E.G. update 'employees' set salary = 1000, vacation = 200 where grade > 7";
    }

    protected UpdateSetListMaker createUpdateSetListMaker(ExecutionContext context, List listBindVars, ParameterResolver namedBindVars) {
        UpdateSetListMaker transformer = new UpdateSetListMaker(listBindVars, namedBindVars, context.getCoherenceQueryLanguage());
        transformer.setExtendedLanguage(context.isExtendedLanguageEnabled());
        return transformer;
    }

    public static class UpdateStatement
    extends AbstractStatement {
        protected final String f_sCache;
        protected final Filter f_filter;
        protected final InvocableMap.EntryProcessor f_processor;

        public UpdateStatement(String sCache, Filter filter, InvocableMap.EntryProcessor processor) {
            this.f_sCache = sCache;
            this.f_filter = filter;
            this.f_processor = processor;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            Map mapResult = ctx.getSession().getCache(this.f_sCache, TypeAssertion.withoutTypeChecking()).invokeAll(this.f_filter, this.f_processor);
            return new DefaultStatementResult(mapResult);
        }

        @Override
        public CompletableFuture<StatementResult> executeAsync(ExecutionContext ctx) {
            return ctx.getSession().getCache(this.f_sCache, TypeAssertion.withoutTypeChecking()).async().invokeAll(this.f_filter, this.f_processor).thenApply(DefaultStatementResult::new);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\").invokeAll(%s, %s)", this.f_sCache, this.f_filter, this.f_processor);
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCache, ctx);
        }
    }
}

