/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import java.io.PrintWriter;
import java.util.List;

public class TruncateCacheStatementBuilder
extends AbstractStatementBuilder<TruncateCacheStatement> {
    public static final TruncateCacheStatementBuilder INSTANCE = new TruncateCacheStatementBuilder();

    @Override
    public TruncateCacheStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = TruncateCacheStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for truncate cache");
        }
        return new TruncateCacheStatement(sCacheName);
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE CACHE 'cache-name'";
    }

    @Override
    public String getDescription() {
        return "Remove all entries from the cache 'cache-name'.";
    }

    public static class TruncateCacheStatement
    extends AbstractStatement {
        protected final String f_sCacheName;

        public TruncateCacheStatement(String sCacheName) {
            this.f_sCacheName = sCacheName;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.getSession().getCache(this.f_sCacheName, TypeAssertion.withoutTypeChecking()).truncate();
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCacheName, ctx);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\")).truncate()", this.f_sCacheName);
        }
    }
}

