/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.UpdateSetListMaker;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.ClassHelper;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class InsertStatementBuilder
extends AbstractStatementBuilder<InsertStatement> {
    public static final InsertStatementBuilder INSTANCE = new InsertStatementBuilder();

    @Override
    public InsertStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = InsertStatementBuilder.getCacheName(term);
        Term termKey = InsertStatementBuilder.getInsertKey(term);
        Term termValue = InsertStatementBuilder.getInsertValue(term);
        UpdateSetListMaker transformer = this.createUpdateSetListMaker(ctx, listBindVars, namedBindVars);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for insert command");
        }
        Object oValue = this.createInsertValue(termValue, transformer);
        Object oKey = this.createInsertKey(termKey, transformer, oValue);
        return new InsertStatement(sCacheName, oKey, oValue);
    }

    @Override
    public String getSyntax() {
        return "INSERT INTO 'cache-name' [KEY (literal | new java-constructor | static method)]\n        VALUE (literal |  new java-constructor | static method)";
    }

    @Override
    public String getDescription() {
        return "Insert into the cache named 'cache-name a new key value pair. If the KEY part\nis omitted then getKey() will be sent to the VALUE object.";
    }

    protected Object createInsertKey(Term termKey, UpdateSetListMaker transformer, Object oValue) {
        Object oKey;
        if (termKey == null) {
            if (oValue == null) {
                throw new RuntimeException("No key specified for insert");
            }
            try {
                oKey = ClassHelper.invoke(oValue, "getKey", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No key specified and missing or inaccessible method: " + oValue.getClass().getName() + ".getKey()");
            }
            catch (Exception e) {
                throw new CohQLException("Error creating key for insert", e);
            }
        }
        try {
            oKey = transformer.makeObjectForKey((NodeTerm)termKey, oValue);
        }
        catch (Exception e) {
            throw new CohQLException("Error creating key (from value) for insert", e);
        }
        return oKey;
    }

    protected Object createInsertValue(Term termValue, UpdateSetListMaker transformer) {
        try {
            if (termValue == null) {
                termValue = Terms.newTerm("literal", AtomicTerm.createNull());
            }
            return transformer.makeObject((NodeTerm)termValue);
        }
        catch (Exception e) {
            throw new CohQLException("Error creating value object", e);
        }
    }

    protected UpdateSetListMaker createUpdateSetListMaker(ExecutionContext ctx, List listBindVars, ParameterResolver namedBindVars) {
        UpdateSetListMaker transformer = new UpdateSetListMaker(listBindVars, namedBindVars, ctx.getCoherenceQueryLanguage());
        transformer.setExtendedLanguage(ctx.isExtendedLanguageEnabled());
        return transformer;
    }

    public static class InsertStatement
    extends AbstractStatement {
        protected final String f_sCacheName;
        protected final Object f_oKey;
        protected final Object f_oValue;

        public InsertStatement(String sCacheName, Object oKey, Object oValue) {
            this.f_sCacheName = sCacheName;
            this.f_oKey = oKey;
            this.f_oValue = oValue;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            Object oResult = ctx.getSession().getCache(this.f_sCacheName, TypeAssertion.withoutTypeChecking()).put(this.f_oKey, this.f_oValue);
            return new DefaultStatementResult(oResult);
        }

        @Override
        public CompletableFuture<StatementResult> executeAsync(ExecutionContext ctx) {
            return ctx.getSession().getCache(this.f_sCacheName, TypeAssertion.withoutTypeChecking()).async().put(this.f_oKey, this.f_oValue).thenApply(DefaultStatementResult::new);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\").put(%s, %s)", this.f_sCacheName, this.f_oKey, this.f_oValue);
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCacheName, ctx);
        }
    }
}

