/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import java.io.PrintWriter;
import java.util.Map;

public class FormattedMapStatementResult
extends DefaultStatementResult {
    private String[] m_asColumnHeaders = null;

    public FormattedMapStatementResult(Object oResult) {
        super(oResult, true);
    }

    @Override
    public void print(PrintWriter writer, String sTitle) {
        if (this.f_oResult instanceof Map) {
            if (sTitle != null) {
                writer.println(sTitle);
            }
            this.printResultsObjectMap(writer, (Map)this.f_oResult, this.f_fShowKeys);
        } else {
            this.printResults(writer, sTitle, this.f_oResult, this.f_fShowKeys);
        }
        writer.flush();
    }

    protected void printResultsObjectMap(PrintWriter writer, Map map, boolean fShowKey) {
        int nKeyMax = -1;
        int[] anValueMax = null;
        for (Map.Entry entry : map.entrySet()) {
            int i;
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (oKey.toString().length() > nKeyMax) {
                nKeyMax = oKey.toString().length();
                if (anValueMax == null) {
                    int nValueLen = this.ensureObjectArray(oValue).length;
                    if (nValueLen == 0) {
                        throw new IllegalArgumentException("Cannot use " + String.valueOf(this.getClass()) + " for Map with no value");
                    }
                    anValueMax = new int[nValueLen];
                    for (i = 0; i < nValueLen; ++i) {
                        anValueMax[i] = 0;
                    }
                }
            }
            Object[] oValueResult = this.ensureObjectArray(oValue);
            i = 0;
            Object[] objectArray = oValueResult;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object o = objectArray[j];
                int nLen = o.toString().length();
                if (nLen > anValueMax[i]) {
                    anValueMax[i] = nLen;
                }
                ++i;
            }
        }
        if (this.m_asColumnHeaders != null && anValueMax != null) {
            if (this.m_asColumnHeaders.length != anValueMax.length + 1) {
                throw new IllegalArgumentException("The number of column headers is " + this.m_asColumnHeaders.length + " which does not match the number of results + key value which is " + (anValueMax.length + 1));
            }
            if (this.m_asColumnHeaders[0].length() > nKeyMax) {
                nKeyMax = this.m_asColumnHeaders[0].length();
            }
            writer.print(this.rightPad(this.m_asColumnHeaders[0].toString(), nKeyMax) + " ");
            for (int i = 1; i < anValueMax.length + 1; ++i) {
                if (this.m_asColumnHeaders[i].length() > anValueMax[i - 1]) {
                    anValueMax[i - 1] = this.m_asColumnHeaders[i].length();
                }
                writer.print(this.rightPad(this.m_asColumnHeaders[i].toString(), anValueMax[i - 1]) + " ");
            }
        }
        if (map.size() > 0) {
            writer.println();
            writer.println(this.underline('-', nKeyMax, anValueMax));
            for (Map.Entry entry : map.entrySet()) {
                Object oValue = entry.getValue();
                if (fShowKey) {
                    writer.print(this.rightPad(entry.getKey().toString(), nKeyMax) + " ");
                }
                Object[] oValueResult = this.ensureObjectArray(oValue);
                int i = 0;
                for (Object o : oValueResult) {
                    writer.print(this.rightPad(o.toString(), anValueMax[i++]) + " ");
                }
                writer.println();
            }
        }
    }

    public void setColumnHeaders(String[] asColumnHeaders) {
        this.m_asColumnHeaders = asColumnHeaders;
    }

    private Object[] ensureObjectArray(Object oValue) {
        Object[] objectArray;
        if (oValue instanceof Object[]) {
            objectArray = (Object[])oValue;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = oValue;
        }
        return objectArray;
    }

    private String underline(char cChar, int nKeyLen, int ... anWidths) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fillChar(cChar, nKeyLen) + " ");
        for (int i = 0; i < anWidths.length; ++i) {
            sb.append(this.fillChar(cChar, anWidths[i]) + " ");
        }
        return sb.toString();
    }

    private String fillChar(char c, int nLen) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nLen; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private String rightPad(String sValue, int nLen) {
        return String.format("%1$-" + nLen + "s", sValue);
    }
}

