/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.internal.SelectListMaker;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.ValueExtractor;
import java.io.PrintWriter;
import java.util.List;

public class DropIndexStatementBuilder
extends AbstractStatementBuilder<DropIndexStatement> {
    public static final DropIndexStatementBuilder INSTANCE = new DropIndexStatementBuilder();

    @Override
    public DropIndexStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = DropIndexStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for drop index");
        }
        Term termExtractor = DropIndexStatementBuilder.getExtractor(term);
        if (termExtractor == null || termExtractor.length() == 0) {
            throw new CohQLException("ValueExtractor(s) needed for drop index");
        }
        SelectListMaker transformer = new SelectListMaker(listBindVars, namedBindVars, ctx.getCoherenceQueryLanguage());
        transformer.makeSelectsForCache(sCacheName, (NodeTerm)termExtractor);
        ValueExtractor extractor = transformer.getResultsAsValueExtractor();
        if (extractor == null) {
            throw new CohQLException("ValueExtractor(s) needed for drop index");
        }
        return new DropIndexStatement(sCacheName, extractor);
    }

    @Override
    public String getSyntax() {
        return "DROP INDEX [ON] 'cache-name' value-extractor-list";
    }

    @Override
    public String getDescription() {
        return "Remove the index made from value-extractor-list from cache 'cache-name'.";
    }

    public static class DropIndexStatement
    extends AbstractStatement {
        protected final String f_sCacheName;
        protected final ValueExtractor f_extractor;

        public DropIndexStatement(String sCacheName, ValueExtractor extractor) {
            this.f_sCacheName = sCacheName;
            this.f_extractor = extractor;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.getSession().getCache(this.f_sCacheName, TypeAssertion.withoutTypeChecking()).removeIndex(this.f_extractor);
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\")).removeIndex(%s)", this.f_sCacheName, this.f_extractor);
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCacheName, ctx);
        }
    }
}

