/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import java.io.PrintWriter;
import java.util.List;

public class DropCacheStatementBuilder
extends AbstractStatementBuilder<DropCacheStatement> {
    public static final DropCacheStatementBuilder INSTANCE = new DropCacheStatementBuilder();

    @Override
    public DropCacheStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = DropCacheStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for drop cache");
        }
        return new DropCacheStatement(sCacheName);
    }

    @Override
    public String getSyntax() {
        return "DROP CACHE 'cache-name'";
    }

    @Override
    public String getDescription() {
        return "Remove the cache 'cache-name' from the cluster.";
    }

    public static class DropCacheStatement
    extends AbstractStatement {
        protected final String f_sCacheName;

        public DropCacheStatement(String sCacheName) {
            this.f_sCacheName = sCacheName;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.getSession().getCache(this.f_sCacheName, TypeAssertion.withoutTypeChecking()).destroy();
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCacheName, ctx);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\")).destroy()", this.f_sCacheName);
        }
    }
}

