/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DefaultStatementResult;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.processor.ConditionalRemove;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DeleteStatementBuilder
extends AbstractStatementBuilder<DeleteStatement> {
    public static final DeleteStatementBuilder INSTANCE = new DeleteStatementBuilder();

    @Override
    public DeleteStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = DeleteStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for delete query");
        }
        Filter filter = DeleteStatementBuilder.ensureFilter(DeleteStatementBuilder.getWhere(term), sCacheName, DeleteStatementBuilder.getAlias(term), listBindVars, namedBindVars, ctx);
        return new DeleteStatement(sCacheName, filter);
    }

    @Override
    public String getSyntax() {
        return "DELETE FROM 'cache-name'[[AS] alias] [WHERE conditional-expression]";
    }

    @Override
    public String getDescription() {
        return "Delete the entries from the cache 'cache-name' that match the conditional\nexpression. If no conditional-expression is given all entries will be deleted!\nUse with Care!";
    }

    public static class DeleteStatement
    extends AbstractStatement {
        protected final String f_sCache;
        protected final Filter f_filter;

        public DeleteStatement(String sCacheName, Filter filter) {
            this.f_sCache = sCacheName;
            this.f_filter = filter;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            Map map = ctx.getSession().getCache(this.f_sCache, TypeAssertion.withoutTypeChecking()).invokeAll(this.f_filter, new ConditionalRemove(AlwaysFilter.INSTANCE()));
            return new DefaultStatementResult(map.entrySet());
        }

        @Override
        public CompletableFuture<StatementResult> executeAsync(ExecutionContext ctx) {
            return ctx.getSession().getCache(this.f_sCache, TypeAssertion.withoutTypeChecking()).async().invokeAll(this.f_filter, new ConditionalRemove(AlwaysFilter.INSTANCE())).thenApply(map -> new DefaultStatementResult(map.entrySet()));
        }

        @Override
        public void sanityCheck(ExecutionContext ctx) {
            this.assertCacheName(this.f_sCache, ctx);
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\").invokeAll(%s, new ConditionalRemove(AlwaysFilter.INSTANCE))", this.f_sCache, this.f_filter);
        }
    }
}

