/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.util.LiteSet;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultStatementResult
implements StatementResult {
    protected final Object f_oResult;
    protected final boolean f_fShowKeys;

    public DefaultStatementResult(Object oResult) {
        this(oResult, true);
    }

    public DefaultStatementResult(Object oResult, boolean fShowKeys) {
        this.f_oResult = oResult;
        this.f_fShowKeys = fShowKeys;
    }

    @Override
    public Object getResult() {
        return this.f_oResult;
    }

    @Override
    public void print(PrintWriter writer, String sTitle) {
        this.printResults(writer, sTitle, this.f_oResult, this.f_fShowKeys);
        writer.flush();
    }

    protected void printResults(PrintWriter writer, String sTitle, Object oResult, boolean fShowKeys) {
        if (oResult == null) {
            return;
        }
        if (sTitle != null) {
            writer.println(sTitle);
        }
        if (oResult instanceof Map) {
            this.printResultsMap(writer, (Map)oResult, fShowKeys);
        } else if (oResult instanceof LiteSet) {
            this.printResultsCollection(writer, (Collection)oResult, fShowKeys);
        } else if (oResult instanceof Collection) {
            this.printResultsCollection(writer, (Collection)oResult, false);
        } else {
            this.printStringOrObject(writer, oResult);
            writer.println();
        }
    }

    protected void printObject(PrintWriter writer, Object oResult, boolean fPrintNewLine, boolean fTopObject) {
        writer.flush();
        if (oResult instanceof Object[]) {
            Object[] aoTuple = (Object[])oResult;
            writer.print("[");
            boolean first = true;
            for (Object t : aoTuple) {
                if (!first) {
                    writer.print(", ");
                }
                first = false;
                this.printStringOrObject(writer, t);
            }
            writer.print("]");
        } else if (oResult instanceof List) {
            if (!fTopObject) {
                writer.print("[");
            }
            this.printCommaSeparatedCollection(writer, (Collection)oResult);
            if (!fTopObject) {
                writer.print("]");
            }
        } else if (oResult instanceof Map) {
            boolean first = true;
            writer.print("{");
            for (Map.Entry me : ((Map)oResult).entrySet()) {
                if (!first) {
                    writer.print(", ");
                }
                first = false;
                this.printStringOrObject(writer, me.getKey(), false);
                writer.print(": ");
                this.printStringOrObject(writer, me.getValue());
            }
            writer.print("}");
        } else if (oResult instanceof Set) {
            if (!fTopObject) {
                writer.print("{");
            }
            this.printCommaSeparatedCollection(writer, (Collection)oResult);
            if (!fTopObject) {
                writer.print("}");
            }
        } else {
            writer.print(oResult);
        }
        if (fPrintNewLine) {
            writer.println();
        }
    }

    protected void printCommaSeparatedCollection(PrintWriter writer, Collection col) {
        boolean first = true;
        for (Object value : col) {
            if (!first) {
                writer.print(", ");
            }
            first = false;
            this.printStringOrObject(writer, value);
        }
    }

    protected void printStringOrObject(PrintWriter writer, Object o) {
        this.printStringOrObject(writer, o, false);
    }

    protected void printStringOrObject(PrintWriter writer, Object o, boolean fNewLine) {
        if (o instanceof String) {
            writer.print("\"" + String.valueOf(o) + "\"");
            if (fNewLine) {
                writer.println();
            }
        } else {
            this.printObject(writer, o, fNewLine, false);
        }
    }

    protected void printResultsCollection(PrintWriter writer, Collection col, boolean fShowKeys) {
        if (col == null) {
            return;
        }
        for (Object o : col) {
            if (!fShowKeys && o instanceof Map.Entry) {
                this.printStringOrObject(writer, ((Map.Entry)o).getValue(), true);
                continue;
            }
            this.printStringOrObject(writer, o, true);
        }
    }

    protected void printResultsMap(PrintWriter writer, Map map, boolean fShowKey) {
        for (Map.Entry entry : map.entrySet()) {
            if (fShowKey) {
                this.printStringOrObject(writer, entry.getKey(), false);
                writer.print(": ");
            }
            this.printStringOrObject(writer, entry.getValue(), true);
        }
    }
}

