/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.statement;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.statement.AbstractStatement;
import com.tangosol.coherence.dslquery.statement.AbstractStatementBuilder;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.TypeAssertion;
import java.io.PrintWriter;
import java.util.List;

public class CreateCacheStatementBuilder
extends AbstractStatementBuilder<CreateCacheStatement> {
    public static final CreateCacheStatementBuilder INSTANCE = new CreateCacheStatementBuilder();

    @Override
    public CreateCacheStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        String sCacheName = CreateCacheStatementBuilder.getCacheName(term);
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw new CohQLException("Cache name needed for create cache");
        }
        return new CreateCacheStatement(sCacheName);
    }

    @Override
    public String getSyntax() {
        return "(ENSURE | CREATE) CACHE 'cache-name'";
    }

    @Override
    public String getDescription() {
        return "Make sure the NamedCache 'cache-name' exists.";
    }

    public static class CreateCacheStatement
    extends AbstractStatement {
        protected final String f_sCache;

        public CreateCacheStatement(String sCache) {
            this.f_sCache = sCache;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.getSession().getCache(this.f_sCache, TypeAssertion.withoutTypeChecking());
            return StatementResult.NULL_RESULT;
        }

        @Override
        public void showPlan(PrintWriter out) {
            out.printf("CacheFactory.getCache(\"%s\"))", this.f_sCache);
        }
    }
}

