/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.util.List;

public class SanityCheckStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    @Override
    public SanityCheckQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        AtomicTerm action = (AtomicTerm)term.termAt(1);
        if ("on".equals(action.getValue())) {
            return new SanityCheckQueryPlusStatement(true);
        }
        if ("off".equals(action.getValue())) {
            return new SanityCheckQueryPlusStatement(false);
        }
        throw new CohQLException("Invalid sanity check command - valid syntax is: " + this.getSyntax());
    }

    @Override
    public String getSyntax() {
        return "SANITY [CHECK] (ON | OFF)";
    }

    @Override
    public String getDescription() {
        return "Controls sanity checking mode to verify a cache exists prior to executing an\noperation on it.";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new SanityCheckCommandOPToken();
    }

    public class SanityCheckQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        protected final boolean f_fSanity;

        protected SanityCheckQueryPlusStatement(boolean fSanity) {
            super(SanityCheckStatementBuilder.this);
            this.f_fSanity = fSanity;
        }

        @Override
        public StatementResult execute(ExecutionContext ctx) {
            ctx.setSanityCheckingEnabled(this.f_fSanity);
            return StatementResult.NULL_RESULT;
        }
    }

    public class SanityCheckCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public SanityCheckCommandOPToken() {
            super(SanityCheckStatementBuilder.this, "sanity", OPToken.IDENTIFIER_NODE, "sanityCheckCommand");
        }

        @Override
        public Term nud(OPParser parser) {
            OPScanner scanner = parser.getScanner();
            String sAction = scanner.getCurrentAsString();
            if ("check".equalsIgnoreCase(sAction)) {
                sAction = scanner.next().getValue();
            }
            if ("on".equals(sAction) || "off".equals(sAction)) {
                scanner.advance();
                return Terms.newTerm(this.getFunctor(), AtomicTerm.createString(sAction));
            }
            return super.nud(parser);
        }
    }
}

