/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.queryplus;

import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.QueryPlus;
import com.tangosol.coherence.dslquery.StatementBuilder;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.config.expression.ParameterResolver;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public class HelpStatementBuilder
extends AbstractQueryPlusStatementBuilder {
    private static final String sEighty = "--------------------------------------------------------------------------------";
    protected final HelpQueryPlusStatement f_command = new HelpQueryPlusStatement();

    @Override
    public HelpQueryPlusStatement realize(ExecutionContext ctx, NodeTerm term, List listBindVars, ParameterResolver namedBindVars) {
        return this.f_command;
    }

    @Override
    public String getSyntax() {
        return "HELP";
    }

    @Override
    public String getDescription() {
        return "Displays the syntax and description of all of the commands";
    }

    @Override
    public AbstractQueryPlusStatementBuilder.AbstractOPToken instantiateOpToken() {
        return new HelpCommandOPToken();
    }

    public class HelpQueryPlusStatement
    extends AbstractQueryPlusStatementBuilder.AbstractStatement {
        @Override
        public StatementResult execute(ExecutionContext ctx) {
            PrintWriter out = ctx.getWriter();
            QueryPlus.DependenciesHelper.usage(out);
            out.println();
            out.println(HelpStatementBuilder.sEighty);
            out.println("BYE |  QUIT ");
            out.println("Exits the command line tool.");
            out.println();
            CoherenceQueryLanguage language = ctx.getCoherenceQueryLanguage();
            Collection<StatementBuilder<?>> colBuilders = language.getStatementBuilders().values();
            for (StatementBuilder<?> builder : colBuilders) {
                out.println(HelpStatementBuilder.sEighty);
                out.println(builder.getSyntax());
                out.println();
                out.println(builder.getDescription());
                out.println();
            }
            out.println(HelpStatementBuilder.sEighty);
            out.println("For WHERE clauses the currently Supported conditionals are:\nComparison operators: =, >, >=, <, <=, <>, [ NOT ] BETWEEN, [ NOT ] LIKE,\n[ NOT ] IN, IS [ NOT ] NULL, CONTAINS [ALL | ANY] *\nLogical operators: (AND, OR, NOT)\nLiteral numbers, and the constants true, false, and null\n\nArguments to operators are properties and converted to Bean style getters and\nthe \".\" operator may be used to make chains of calls. The optional alias may be\nprepended onto the beginning of these path expressions. The Pseudo functions\nkey(), and value() may be used to specify the use of a key as in\n\"key() between 10 and 50\".\nThe value() pseudo function is shorthand for the entire element as is the alias.\nThe key() pseudo function my be specified as key(alias) for compatibility with\nJPQL.");
            return StatementResult.NULL_RESULT;
        }
    }

    public class HelpCommandOPToken
    extends AbstractQueryPlusStatementBuilder.AbstractOPToken {
        public HelpCommandOPToken() {
            super("help", OPToken.IDENTIFIER_NODE, "showHelp");
        }

        @Override
        public Term nud(OPParser parser) {
            return Terms.newTerm(this.getFunctor());
        }
    }
}

