/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.operator;

import com.tangosol.coherence.dslquery.operator.BaseOperator;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;
import com.tangosol.util.filter.ComparisonFilter;
import java.util.Arrays;

public abstract class ComparisonOperator
extends BaseOperator<ComparisonFilter> {
    protected ComparisonOperator(String sSymbol, String ... asAliases) {
        super(sSymbol, true, asAliases);
    }

    @Override
    public ComparisonFilter makeFilter(Term termLeft, Term termRight, TermWalker walker) {
        boolean fRightHasIdentifiers;
        String sRightFunctor = termRight.getFunctor();
        String sLeftFunctor = termLeft.getFunctor();
        boolean fLeftIsIdentifier = "identifier".equals(sLeftFunctor);
        boolean fRightIsIdentifier = "identifier".equals(sRightFunctor);
        boolean fRightIsBinding = "bindingNode".equals(sRightFunctor);
        boolean fLeftHasIdentifiers = Arrays.stream(termLeft.children()).anyMatch(t -> "identifier".equals(t.getFunctor()));
        boolean bl = fRightHasIdentifiers = !fRightIsBinding && Arrays.stream(termRight.children()).anyMatch(t -> "identifier".equals(t.getFunctor()));
        if (fRightIsIdentifier && fLeftIsIdentifier || fLeftHasIdentifiers && fRightHasIdentifiers) {
            String sMsg = "The use of identifier on both sides of an expression is not supported";
            throw new UnsupportedOperationException(sMsg);
        }
        if (sRightFunctor.equals("identifier") && !((AtomicTerm)termRight.termAt(1)).getValue().equalsIgnoreCase("null") && !((AtomicTerm)termRight.termAt(1)).getValue().equalsIgnoreCase("true") && !((AtomicTerm)termRight.termAt(1)).getValue().equalsIgnoreCase("false") || sRightFunctor.equals("derefNode") || sRightFunctor.equals("callNode")) {
            return this.flip().makeFilter(termRight, termLeft, walker);
        }
        return (ComparisonFilter)super.makeFilter(termLeft, termRight, walker);
    }

    public abstract BaseOperator<ComparisonFilter> flip();
}

