/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.operator;

import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class BaseOperator<F extends Filter> {
    protected final String f_sSymbol;
    protected final String[] f_asAlias;
    protected final boolean f_fConditional;

    protected BaseOperator(String sSymbol, boolean fConditional, String ... asAlias) {
        this.f_sSymbol = sSymbol;
        this.f_fConditional = fConditional;
        this.f_asAlias = asAlias;
    }

    public String getSymbol() {
        return this.f_sSymbol;
    }

    public String[] getAliases() {
        return this.f_asAlias;
    }

    public F makeFilter(Term termLeft, Term termRight, TermWalker walker) {
        Object oLeft = walker.walk(termLeft);
        Object oRight = walker.walk(termRight);
        return this.makeFilter(oLeft, oRight);
    }

    public F makeFilter(Object oLeft, Object oRight) {
        throw new UnsupportedOperationException("Unsupported binary operator (" + this.getSymbol() + ")");
    }

    public ValueExtractor makeExtractor(Term termLeft, Term termRight, TermWalker walker) {
        Object oLeft = walker.walk(termLeft);
        Object oRight = walker.walk(termRight);
        return this.makeExtractor(oLeft, oRight);
    }

    public ValueExtractor makeExtractor(Object oLeft, Object oRight) {
        throw new UnsupportedOperationException("Unsupported binary operator (" + this.getSymbol() + ")");
    }

    public boolean isConditional() {
        return this.f_fConditional;
    }

    public abstract void addToTokenTable(TokenTable var1);

    public String toString() {
        return "BaseOperator(symbol=" + this.f_sSymbol + ", aliases=" + Arrays.toString(this.f_asAlias) + ", conditional=" + this.f_fConditional + ")";
    }

    protected void addAliases(TokenTable tokenTable) {
        String[] asAlias;
        String sSymbol = this.getSymbol();
        for (String sAlias : asAlias = this.getAliases()) {
            tokenTable.alias(sAlias, sSymbol);
        }
    }

    protected static Set unmodifiableSet(Object oValue) {
        if (oValue instanceof Set) {
            return (Set)oValue;
        }
        Set set = oValue instanceof Object[] ? new ImmutableArrayList((Object[])oValue).getSet() : (oValue instanceof Collection ? new ImmutableArrayList((Collection)oValue).getSet() : Collections.singleton(oValue));
        return set;
    }
}

