/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.internal;

import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.internal.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Extractors;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import com.tangosol.util.extractor.UniversalUpdater;
import com.tangosol.util.processor.CompositeProcessor;
import com.tangosol.util.processor.NumberIncrementor;
import com.tangosol.util.processor.NumberMultiplier;
import com.tangosol.util.processor.UpdaterProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class UpdateSetListMaker
extends AbstractCoherenceQueryWalker {
    protected NodeTerm m_term;
    protected Object[] m_aoResults;
    protected boolean m_fRValueExpected = false;

    public UpdateSetListMaker(List indexedBindVars, ParameterResolver namedBindVars, CoherenceQueryLanguage language) {
        super(indexedBindVars, namedBindVars, language);
    }

    public Object[] getResults() {
        return this.m_aoResults;
    }

    public InvocableMap.EntryProcessor getResultAsEntryProcessor() {
        if (this.m_aoResults.length == 1) {
            return (InvocableMap.EntryProcessor)this.m_aoResults[0];
        }
        InvocableMap.EntryProcessor[] aProcessors = new InvocableMap.EntryProcessor[this.m_aoResults.length];
        for (int i = 0; i < this.m_aoResults.length; ++i) {
            aProcessors[i] = (InvocableMap.EntryProcessor)this.m_aoResults[i];
        }
        return new CompositeProcessor(aProcessors);
    }

    public InvocableMap.EntryProcessor makeSetList() {
        this.m_aoResults = new Object[this.m_term.length()];
        this.setResult(null);
        this.acceptTarget();
        return this.getResultAsEntryProcessor();
    }

    public InvocableMap.EntryProcessor makeSetList(NodeTerm term) {
        this.m_term = term;
        return this.makeSetList();
    }

    public Object makeObject(NodeTerm term) {
        this.m_term = term;
        this.m_aoResults = null;
        this.m_fRValueExpected = true;
        this.setResult(null);
        this.m_term.accept(this);
        String functor = term.getFunctor();
        if (this.needsObjectCreation(functor, term)) {
            Object oResult = this.reflectiveMakeObject(false, this.getResult());
            this.setResult(oResult);
        }
        return this.getResult();
    }

    public Object makeObjectForKey(NodeTerm term, Object oValue) {
        this.m_term = term;
        this.m_aoResults = null;
        this.m_fRValueExpected = true;
        this.setResult(null);
        this.m_term.accept(this);
        String sFunctor = term.getFunctor();
        Object oResult = this.getResult();
        if (sFunctor.equals("unaryOperatorNode")) {
            return this.getResult();
        }
        if (sFunctor.equals("callNode") && oResult instanceof ValueExtractor) {
            ValueExtractor extractor = this.makeValueExtractor(oResult);
            oResult = extractor.extract(oValue);
            this.setResult(oResult);
            return oResult;
        }
        if (sFunctor.equals("identifier") && oResult instanceof String) {
            ValueExtractor extractor = this.makeValueExtractor(oResult);
            oResult = extractor.extract(oValue);
            this.setResult(oResult);
            return oResult;
        }
        if (sFunctor.equals("derefNode")) {
            Object[] aoPath = (Object[])oResult;
            int nCount = aoPath.length;
            boolean fUseExtractor = false;
            if (!(aoPath[nCount - 1] instanceof UniversalExtractor)) {
                fUseExtractor = true;
            } else {
                for (int i = 0; i < nCount - 1; ++i) {
                    if (!(aoPath[i] instanceof UniversalExtractor)) continue;
                    fUseExtractor = true;
                    break;
                }
            }
            if (fUseExtractor) {
                ValueExtractor ve = this.makeValueExtractor(oResult);
                oResult = ve.extract(oValue);
                this.setResult(oResult);
                return oResult;
            }
        }
        try {
            if (this.needsObjectCreation(sFunctor, term)) {
                oResult = this.reflectiveMakeObject(false, oResult);
                this.setResult(oResult);
            }
        }
        catch (Exception e) {
            if (sFunctor.equals(".object.")) {
                throw new RuntimeException(e.getMessage());
            }
            ValueExtractor extractor = this.makeValueExtractor(oResult);
            oResult = extractor.extract(oValue);
            this.setResult(oResult);
        }
        return oResult;
    }

    @Override
    public void acceptNode(String sFunctor, NodeTerm term) {
        if (this.m_fExtendedLanguage) {
            switch (sFunctor) {
                case ".list.": {
                    super.acceptNode("callNode", new NodeTerm("callNode", term));
                    break;
                }
                case ".bag.": {
                    super.acceptNode("callNode", new NodeTerm("callNode", term));
                    break;
                }
                case ".pair.": {
                    super.acceptNode("callNode", new NodeTerm("callNode", term));
                    break;
                }
                case ".object.": {
                    super.acceptNode("callNode", new NodeTerm("callNode", term));
                    break;
                }
                default: {
                    super.acceptNode(sFunctor, term);
                    break;
                }
            }
        } else {
            super.acceptNode(sFunctor, term);
        }
    }

    @Override
    protected void acceptList(NodeTerm termList) {
        int cTerms = termList.length();
        Object[] ao = new Object[cTerms];
        for (int i = 1; i <= cTerms; ++i) {
            termList.termAt(i).accept(this);
            ao[i - 1] = this.getResult();
        }
        this.setResult(ao);
    }

    @Override
    protected void acceptIdentifier(String sIdentifier) {
        if (this.acceptIdentifierInternal(sIdentifier)) {
            return;
        }
        this.setResult(sIdentifier);
    }

    @Override
    protected void acceptBinaryOperator(String sOperator, Term termLeft, Term termRight) {
        switch (sOperator) {
            case "==": {
                this.m_fRValueExpected = false;
                termLeft.accept(this);
                ValueUpdater updater = this.makeValueUpdater(this.getResult());
                this.m_fRValueExpected = true;
                termRight.accept(this);
                UpdaterProcessor oResult = this.getResult();
                if (this.needsObjectCreation(termRight.getFunctor(), termRight)) {
                    oResult = this.reflectiveMakeObject(false, this.getResult());
                    this.setResult(oResult);
                }
                oResult = new UpdaterProcessor(updater, oResult);
                this.setResult(oResult);
                break;
            }
            case "+": {
                termLeft.accept(this);
                String sIdentifier = this.makePathString(this.getResult());
                termRight.accept(this);
                if (termRight.isLeaf()) {
                    NumberIncrementor incrementor = new NumberIncrementor(sIdentifier, (Number)this.getResult(), false);
                    this.setResult(incrementor);
                    break;
                }
                throw new RuntimeException("Argument to binary operator '+' not atomic");
            }
            case "*": {
                termLeft.accept(this);
                String sIdentifier = this.makePathString(this.getResult());
                termRight.accept(this);
                if (termRight.isLeaf()) {
                    NumberMultiplier multiplier = new NumberMultiplier(sIdentifier, (Number)this.getResult(), false);
                    this.setResult(multiplier);
                    break;
                }
                throw new RuntimeException("Argument to binary operator '*' not atomic");
            }
            default: {
                throw new RuntimeException("Unknown binary operator: " + sOperator);
            }
        }
    }

    @Override
    protected void acceptUnaryOperator(String sOperator, Term term) {
        switch (sOperator) {
            case "new": {
                term.accept(this);
                Object oResult = this.reflectiveMakeObject(true, this.getResult());
                this.setResult(oResult);
                break;
            }
            case "-": {
                term.accept(this);
                if (!this.m_atomicTerm.isNumber()) break;
                Number number = this.m_atomicTerm.negativeNumber((Number)this.getResult());
                this.setResult(number);
                break;
            }
            case "+": {
                term.accept(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknown unary operator: " + sOperator);
            }
        }
    }

    @Override
    protected void acceptCall(String sFunctionName, NodeTerm term) {
        int nCount = term.length();
        Object[] aObjects = new Object[nCount];
        for (int i = 1; i <= nCount; ++i) {
            Term termChild = term.termAt(i);
            termChild.accept(this);
            Object oResult = this.getResult();
            if (this.needsObjectCreation(termChild.getFunctor(), termChild)) {
                oResult = this.reflectiveMakeObject(false, oResult);
            }
            aObjects[i - 1] = oResult;
            this.setResult(oResult);
        }
        if (sFunctionName.equalsIgnoreCase("key") && nCount == 0) {
            KeyExtractor keyExtractor = new KeyExtractor(IdentityExtractor.INSTANCE);
            this.setResult(keyExtractor);
        } else if (sFunctionName.equalsIgnoreCase("value") && nCount == 0) {
            this.setResult(IdentityExtractor.INSTANCE);
        } else if (this.m_fExtendedLanguage) {
            switch (sFunctionName) {
                case ".list.": {
                    this.setResult(this.makeListLiteral(aObjects));
                    break;
                }
                case ".bag.": {
                    this.setResult(this.makeSetOrMapLiteral(aObjects));
                    break;
                }
                case ".pair.": {
                    this.setResult(this.makePairLiteral(aObjects));
                    break;
                }
                case "List": {
                    this.setResult(this.makeListLiteral(aObjects));
                    break;
                }
                case "Set": {
                    this.setResult(this.makeSetLiteral(aObjects));
                    break;
                }
                case "Map": {
                    this.setResult(this.makeMapLiteral(aObjects));
                    break;
                }
                default: {
                    this.setResult(this.asUniversalExtractor(sFunctionName, aObjects));
                    break;
                }
            }
        } else {
            this.setResult(this.asUniversalExtractor(sFunctionName, aObjects));
        }
    }

    @Override
    protected void acceptPath(NodeTerm term) {
        int cTerms = term.length();
        Object[] ao = new Object[cTerms];
        for (int i = 1; i <= cTerms; ++i) {
            term.termAt(i).accept(this);
            ao[i - 1] = this.getResult();
        }
        this.setResult(ao);
    }

    private UniversalExtractor asUniversalExtractor(String sFunction, Object[] aoArgs) {
        if (aoArgs == null || aoArgs.length == 0) {
            return new UniversalExtractor(sFunction + "()");
        }
        return new UniversalExtractor(sFunction + "()", aoArgs);
    }

    protected void acceptTarget() {
        int nCount = this.m_term.length();
        for (int i = 1; i <= nCount; ++i) {
            this.m_term.termAt(i).accept(this);
            this.m_aoResults[i - 1] = this.getResult();
        }
    }

    public String makePathString(Object oValue) {
        if (oValue instanceof IdentityExtractor) {
            return null;
        }
        if (oValue instanceof String) {
            return (String)oValue;
        }
        if (oValue instanceof UniversalExtractor) {
            UniversalExtractor extractor = (UniversalExtractor)oValue;
            return extractor.getMethodName();
        }
        if (oValue instanceof Object[]) {
            Object[] aoParts = (Object[])oValue;
            StringBuilder sb = new StringBuilder();
            for (Object part : aoParts) {
                sb.append('.').append(this.makePathString(part));
            }
            return sb.substring(1);
        }
        return null;
    }

    public ValueUpdater makeValueUpdater(Object oValue) {
        if (oValue instanceof IdentityExtractor) {
            return null;
        }
        if (oValue instanceof String) {
            return new UniversalUpdater(this.f_propertyBuilder.updaterStringFor((String)oValue));
        }
        if (oValue instanceof UniversalExtractor) {
            UniversalExtractor extractor = (UniversalExtractor)oValue;
            return new UniversalUpdater(extractor.getMethodName());
        }
        if (oValue instanceof ValueUpdater) {
            return (ValueUpdater)oValue;
        }
        if (oValue instanceof Object[]) {
            Object[] aoObjects = (Object[])oValue;
            ValueUpdater updater = this.makeValueUpdater(aoObjects[aoObjects.length - 1]);
            ValueExtractor[] aExtractors = new ValueExtractor[aoObjects.length - 1];
            for (int i = 0; i < aoObjects.length - 1; ++i) {
                aExtractors[i] = this.makeValueExtractor(aoObjects[i]);
            }
            return new CompositeUpdater(new ChainedExtractor(aExtractors), updater);
        }
        throw new RuntimeException("Unable to determine field to set from: " + String.valueOf(oValue));
    }

    public ValueExtractor makeValueExtractor(Object oValue) {
        if (oValue instanceof String) {
            return Extractors.extract(this.f_propertyBuilder.extractorStringFor((String)oValue));
        }
        if (oValue instanceof ValueExtractor) {
            return (ValueExtractor)oValue;
        }
        if (oValue instanceof Object[]) {
            Object[] aoObjects = (Object[])oValue;
            ValueExtractor[] aExtractors = new ValueExtractor[aoObjects.length];
            for (int i = 0; i < aoObjects.length; ++i) {
                aExtractors[i] = this.makeValueExtractor(aoObjects[i]);
            }
            return new ChainedExtractor(aExtractors);
        }
        throw new RuntimeException("Unable to determine extractor for: " + String.valueOf(oValue));
    }

    protected boolean needsObjectCreation(String sFunctor, Term term) {
        if (sFunctor.equals("derefNode")) {
            return true;
        }
        if (sFunctor.equals("callNode")) {
            if (this.m_fExtendedLanguage) {
                String sf = term.termAt(1).getFunctor();
                return !sf.equals("List") && !sf.equals("Set") && !sf.equals("Map");
            }
            return true;
        }
        return this.m_fExtendedLanguage && sFunctor.equals(".object.");
    }

    protected Object makePairLiteral(Object[] aoArgs) {
        int count;
        int n = count = aoArgs != null ? aoArgs.length : 0;
        if (count == 2) {
            return aoArgs;
        }
        throw new RuntimeException("Pairs must be length 2 instead of length " + count);
    }

    protected Object makeListLiteral(Object[] aoArgs) {
        return Arrays.asList(aoArgs);
    }

    protected Object makeSetLiteral(Object[] aoArgs) {
        return new HashSet<Object>(Arrays.asList(aoArgs));
    }

    protected Object makeSetOrMapLiteral(Object[] aoArgs) {
        int nCount = aoArgs.length;
        if (nCount > 0 && this.isAllPairs(aoArgs)) {
            HashMap<Object, Object> map = new HashMap<Object, Object>(nCount);
            for (int i = 0; i < nCount; ++i) {
                Object[] aoObjects = (Object[])aoArgs[i];
                map.put(aoObjects[0], aoObjects[1]);
            }
            return map;
        }
        return this.makeSetLiteral(aoArgs);
    }

    private boolean isAllPairs(Object[] aoArgs) {
        for (Object obj : aoArgs) {
            Object[] aobj = null;
            if (obj instanceof Object[]) {
                aobj = (Object[])obj;
            }
            if (aobj != null && aobj.length == 2) continue;
            return false;
        }
        return true;
    }

    protected Object makeMapLiteral(Object[] aoArgs) {
        int nCount = aoArgs.length;
        HashMap<Object, Object> map = new HashMap<Object, Object>(nCount);
        for (int i = 0; i < nCount; ++i) {
            Object oValue = aoArgs[i];
            Object[] aoObjects = null;
            if (oValue instanceof Object[]) {
                aoObjects = (Object[])oValue;
            }
            if (aoObjects == null || aoObjects.length != 2) {
                throw new RuntimeException("Incorrect for argument to literal Map :" + Arrays.toString(aoObjects));
            }
            map.put(aoObjects[0], aoObjects[1]);
        }
        return map;
    }
}

