/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery.function;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.BigDecimalAverage;
import com.tangosol.util.aggregator.BigDecimalMax;
import com.tangosol.util.aggregator.BigDecimalMin;
import com.tangosol.util.aggregator.BigDecimalSum;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.aggregator.DoubleAverage;
import com.tangosol.util.aggregator.DoubleMax;
import com.tangosol.util.aggregator.DoubleMin;
import com.tangosol.util.aggregator.DoubleSum;
import com.tangosol.util.aggregator.LongMax;
import com.tangosol.util.aggregator.LongMin;
import com.tangosol.util.aggregator.LongSum;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.PofExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.UniversalExtractor;

public final class FunctionBuilders {
    public static ParameterizedBuilder<BigDecimalAverage> BIG_DECIMAL_AVERAGE_FUNCTION_BUILDER = new ParameterizedBuilder<BigDecimalAverage>(){

        @Override
        public BigDecimalAverage realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new BigDecimalAverage(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<BigDecimalMax> BIG_DECIMAL_MAX_FUNCTION_BUILDER = new ParameterizedBuilder<BigDecimalMax>(){

        @Override
        public BigDecimalMax realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new BigDecimalMax(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<BigDecimalMin> BIG_DECIMAL_MIN_FUNCTION_BUILDER = new ParameterizedBuilder<BigDecimalMin>(){

        @Override
        public BigDecimalMin realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new BigDecimalMin(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<BigDecimalSum> BIG_DECIMAL_SUM_FUNCTION_BUILDER = new ParameterizedBuilder<BigDecimalSum>(){

        @Override
        public BigDecimalSum realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new BigDecimalSum(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<String> CONCAT_FUNCTION_BUILDER = (resolver, loader, listParameters) -> {
        StringBuilder sb = new StringBuilder();
        if (listParameters.size() < 2) {
            throw new CohQLException("CONCAT requires at least two arguments");
        }
        for (Parameter listParameter : listParameters) {
            sb.append(listParameter.evaluate(resolver).get().toString());
        }
        return sb.toString();
    };
    public static ParameterizedBuilder<Count> COUNT_FUNCTION_BUILDER = new ParameterizedBuilder<Count>(){

        @Override
        public Count realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new Count();
        }
    };
    public static ParameterizedBuilder<DoubleAverage> DOUBLE_AVERAGE_FUNCTION_BUILDER = new ParameterizedBuilder<DoubleAverage>(){

        @Override
        public DoubleAverage realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new DoubleAverage(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<DoubleMax> DOUBLE_MAX_FUNCTION_BUILDER = new ParameterizedBuilder<DoubleMax>(){

        @Override
        public DoubleMax realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new DoubleMax(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<DoubleMin> DOUBLE_MIN_FUNCTION_BUILDER = new ParameterizedBuilder<DoubleMin>(){

        @Override
        public DoubleMin realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new DoubleMin(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<DoubleSum> DOUBLE_SUM_FUNCTION_BUILDER = new ParameterizedBuilder<DoubleSum>(){

        @Override
        public DoubleSum realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new DoubleSum(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<LongMax> LONG_MAX_FUNCTION_BUILDER = new ParameterizedBuilder<LongMax>(){

        @Override
        public LongMax realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new LongMax(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<LongMin> LONG_MIN_FUNCTION_BUILDER = new ParameterizedBuilder<LongMin>(){

        @Override
        public LongMin realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new LongMin(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<LongSum> LONG_SUM_FUNCTION_BUILDER = new ParameterizedBuilder<LongSum>(){

        @Override
        public LongSum realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return new LongSum(FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class));
        }
    };
    public static ParameterizedBuilder<ReflectionExtractor> METHOD_CALL_FUNCTION_BUILDER = new ParameterizedBuilder<ReflectionExtractor>(){

        @Override
        public ReflectionExtractor realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            Parameter paramFunction = resolver.resolve("functionName");
            Value value = paramFunction.evaluate(resolver);
            String sFunction = (String)value.get();
            if (listParameters.isEmpty()) {
                return new ReflectionExtractor(sFunction);
            }
            Object[] ao = new Object[listParameters.size()];
            int i = 0;
            for (Parameter parameter : listParameters) {
                ao[i++] = parameter.evaluate(resolver).get();
            }
            return new ReflectionExtractor(sFunction, ao);
        }
    };
    public static ParameterizedBuilder<IdentityExtractor> VALUE_FUNCTION_BUILDER = new ParameterizedBuilder<IdentityExtractor>(){

        @Override
        public IdentityExtractor realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return IdentityExtractor.INSTANCE;
        }
    };
    public static ParameterizedBuilder<ValueExtractor> KEY_FUNCTION_BUILDER = new ParameterizedBuilder<ValueExtractor>(){

        @Override
        public ValueExtractor realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            IdentityExtractor extractor = listParameters.isEmpty() ? IdentityExtractor.INSTANCE : FunctionBuilders.getFirstParameter(resolver, listParameters, ValueExtractor.class);
            return this.realizeExtractor(extractor);
        }

        protected ValueExtractor realizeExtractor(ValueExtractor extractorOrig) {
            Class<?> clsExtractor = extractorOrig.getClass();
            if (UniversalExtractor.class.equals(clsExtractor)) {
                UniversalExtractor extractor = (UniversalExtractor)extractorOrig;
                return new UniversalExtractor(extractor.getMethodName() + "()", extractor.getParameters(), 1);
            }
            if (ReflectionExtractor.class.equals(clsExtractor)) {
                ReflectionExtractor extractor = (ReflectionExtractor)extractorOrig;
                return new ReflectionExtractor(extractor.getMethodName(), extractor.getParameters(), 1);
            }
            if (PofExtractor.class.equals(clsExtractor)) {
                PofExtractor extractor = (PofExtractor)extractorOrig;
                return new PofExtractor(extractor.getClassExtracted(), extractor.getNavigator(), 1);
            }
            if (ChainedExtractor.class.equals(clsExtractor)) {
                ValueExtractor[] extractors = ((ChainedExtractor)extractorOrig).getExtractors();
                extractors[0] = this.realizeExtractor(extractors[0]);
                ((ChainedExtractor)extractorOrig).ensureTarget();
                return extractorOrig;
            }
            return new KeyExtractor(extractorOrig);
        }
    };

    protected static <V> V getFirstParameter(ParameterResolver resolver, ParameterList listParameters, Class<V> clzExpected) {
        Base.azzert(!listParameters.isEmpty());
        Parameter parameter = (Parameter)listParameters.iterator().next();
        Value value = parameter.evaluate(resolver);
        Object oResult = value.get();
        Base.azzert(oResult != null);
        Base.azzert(clzExpected.isAssignableFrom(oResult.getClass()));
        return (V)oResult;
    }
}

