/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.StatementExecutor;
import com.tangosol.coherence.dslquery.queryplus.AbstractQueryPlusStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.CommandsStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.ExtendedLanguageStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.HelpStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.SanityCheckStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.ServicesStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.SetTimeoutStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.TraceStatementBuilder;
import com.tangosol.coherence.dslquery.queryplus.WheneverStatementBuilder;
import com.tangosol.coherence.dslquery.token.SQLPeekOPToken;
import com.tangosol.coherence.dsltools.precedence.PeekOPToken;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryPlus {
    private static final String END_OF_STATEMENT = ";";
    private static final String PROMPT = "CohQL> ";
    protected final Dependencies f_dependencies;
    protected final ExecutionContext f_context;
    protected final StatementExecutor f_executor;
    protected final boolean f_fEcho;
    protected static boolean s_fUsingJline = false;

    public QueryPlus(Dependencies dependencies) {
        Base.azzert(dependencies != null);
        this.f_dependencies = dependencies;
        this.f_executor = dependencies.getStatementExecutor();
        this.f_context = new ExecutionContext();
        this.f_fEcho = dependencies.isEcho();
        this.f_context.setTimeout(dependencies.getTimeout());
        this.f_context.setTraceEnabled(dependencies.isTraceEnabled());
        this.f_context.setSanityCheckingEnabled(dependencies.isSanityChecking());
        this.f_context.setExtendedLanguage(dependencies.isExtendedLanguageEnabled());
        this.f_context.setWriter(dependencies.getOutputWriter());
        this.f_context.setCoherenceQueryLanguage(dependencies.getCoherenceQueryLanguage());
        this.f_context.setTitle(dependencies.getTitle());
        this.f_context.setSilentMode(dependencies.isSilent());
        this.f_context.setReader(dependencies.getReader());
        this.initializeLanguage();
    }

    public void run() {
        PrintWriter out = this.f_dependencies.getOutputWriter();
        String sGarFile = this.f_dependencies.getGarFileName();
        for (String sStatement : this.f_dependencies.getStatements()) {
            if (!this.evalLine(sStatement)) break;
        }
        for (String sFile : this.f_dependencies.getFiles()) {
            if (!this.processFile(sFile)) break;
        }
        out.flush();
        if (this.f_dependencies.isExitWhenProcessingComplete()) {
            return;
        }
        if (!this.f_context.isSilent()) {
            out.println("Coherence Command Line Tool");
            out.flush();
        }
        this.repl();
    }

    public void repl() {
        BufferedReader reader = this.f_context.getReader();
        PrintWriter writer = this.f_context.getWriter();
        boolean fSilent = this.f_context.isSilent();
        boolean fWorking = true;
        while (fWorking) {
            try {
                String[] statements;
                if (!fSilent && !s_fUsingJline) {
                    writer.println();
                    writer.print(PROMPT);
                }
                writer.flush();
                String sLine = reader.readLine();
                if (sLine == null) {
                    fWorking = false;
                    continue;
                }
                boolean fContainsEOS = sLine.contains(END_OF_STATEMENT);
                for (String statement : statements = sLine.split(END_OF_STATEMENT)) {
                    if ((statement = statement.trim()).isEmpty()) continue;
                    if (this.f_fEcho) {
                        StringBuffer sb = new StringBuffer(statement);
                        if (fContainsEOS) {
                            sb.append(END_OF_STATEMENT);
                        }
                        writer.println(sb.toString());
                        writer.flush();
                    }
                    fWorking = statement != null && this.evalLine(statement);
                }
            }
            catch (IOException e) {
                if (fSilent) {
                    return;
                }
                writer.println("\n" + e.getMessage());
            }
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.f_context;
    }

    protected void initializeLanguage() {
        this.addStatement(new CommandsStatementBuilder());
        this.addStatement(new ExtendedLanguageStatementBuilder());
        this.addStatement(new HelpStatementBuilder());
        this.addStatement(new SanityCheckStatementBuilder());
        this.addStatement(new ServicesStatementBuilder());
        CoherenceQueryLanguage language = this.f_context.getCoherenceQueryLanguage();
        this.addStatement(new TraceStatementBuilder(language.sqlTokenTable().lookup("trace")));
        this.addStatement(new WheneverStatementBuilder());
        this.addAlterSessionStatement();
    }

    protected void addStatement(AbstractQueryPlusStatementBuilder builder) {
        AbstractQueryPlusStatementBuilder.AbstractOPToken token = builder.instantiateOpToken();
        CoherenceQueryLanguage language = this.f_context.getCoherenceQueryLanguage();
        language.addStatement(token.getFunctor(), builder);
        language.extendedSqlTokenTable().addToken(token);
        language.sqlTokenTable().addToken(token);
    }

    protected void addAlterSessionStatement() {
        CoherenceQueryLanguage language = this.f_context.getCoherenceQueryLanguage();
        SetTimeoutStatementBuilder bldrTimeout = new SetTimeoutStatementBuilder();
        AbstractQueryPlusStatementBuilder.AbstractOPToken tokenTimeout = bldrTimeout.instantiateOpToken();
        language.addStatement(tokenTimeout.getFunctor(), bldrTimeout);
        SQLPeekOPToken tokenSet = new SQLPeekOPToken("set", tokenTimeout);
        SQLPeekOPToken tokenSession = new SQLPeekOPToken("session", tokenSet);
        TokenTable tokenTableExt = language.extendedSqlTokenTable();
        PeekOPToken tokenExtAlter = (PeekOPToken)tokenTableExt.lookup("alter");
        tokenExtAlter.addOPToken(tokenSession);
        TokenTable tokenTableSql = language.sqlTokenTable();
        PeekOPToken tokenSqlAlter = (PeekOPToken)tokenTableSql.lookup("alter");
        tokenSqlAlter.addOPToken(tokenSession);
    }

    protected Object query(String sQuery) {
        return this.f_context.getStatementExecutor().execute(new StringReader(sQuery), this.f_context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFile(String sFileName) {
        String sLine = "@ '" + sFileName.trim() + "'";
        boolean fSavedSilent = this.f_context.isSilent();
        this.f_context.setSilentMode(true);
        try {
            this.f_context.getStatementExecutor().execute(new StringReader(sLine), this.f_context);
        }
        catch (Exception e) {
            PrintWriter out = this.f_context.getWriter();
            out.println(e.getMessage());
            if (this.f_context.isTraceEnabled()) {
                e.printStackTrace(out);
            }
            if (this.f_context.isStopOnError()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.f_context.setSilentMode(fSavedSilent);
        }
        return true;
    }

    protected boolean evalLine(String sLine) {
        block6: {
            try {
                if (((String)sLine).trim().isEmpty()) {
                    return true;
                }
                if (((String)sLine).equals("quit") || ((String)sLine).equals("bye")) {
                    return false;
                }
                if (((String)sLine).startsWith(".")) {
                    String ln = ((String)sLine).substring(1).trim();
                    sLine = "@ '" + ln + "'";
                }
                this.query((String)sLine);
            }
            catch (Exception e) {
                PrintWriter writer = this.f_context.getWriter();
                writer.println(e.getMessage());
                if (this.f_context.isTraceEnabled()) {
                    e.printStackTrace(writer);
                }
                if (!this.f_context.isStopOnError()) break block6;
                return false;
            }
        }
        return true;
    }

    public static BufferedReader getJlineReader(OutputStream output, InputStream input, boolean fSilent) {
        try {
            Class<?> clzJLineReader = Class.forName("org.jline.reader.LineReader");
            Class<?> clzJLineReaderBldr = Class.forName("org.jline.reader.LineReaderBuilder");
            Object builder = ClassHelper.invokeStatic(clzJLineReaderBldr, "builder", null);
            String fieldHistoryFile = (String)clzJLineReader.getField("HISTORY_FILE").get(clzJLineReader);
            File fileHistory = new File(".cohql-history");
            if (!fileHistory.exists()) {
                fileHistory.createNewFile();
            }
            builder = ClassHelper.invoke(builder, "variable", new Object[]{fieldHistoryFile, fileHistory});
            final Object jlineReader = ClassHelper.invoke(builder, "build", null);
            s_fUsingJline = true;
            return new BufferedReader((Reader)new InputStreamReader(input)){

                @Override
                public String readLine() throws IOException {
                    try {
                        String sLine = (String)ClassHelper.invoke(jlineReader, "readLine", new Object[]{QueryPlus.PROMPT});
                        ClassHelper.invoke(jlineReader, "redrawLine", null);
                        ClassHelper.invoke(jlineReader, "flush", null);
                        return sLine;
                    }
                    catch (Throwable e) {
                        String eCauseName;
                        Throwable eCause = e.getCause();
                        String string = eCauseName = eCause == null ? "" : eCause.getClass().getName();
                        if (e.getClass().getName().contains("InvocationTargetException") && (eCauseName.contains("EndOfFileException") || eCauseName.contains("org.jline.reader.UserInterruptException"))) {
                            return null;
                        }
                        throw Base.ensureRuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            if (!fSilent) {
                PrintWriter writer = new PrintWriter(output);
                writer.println("jline library cannot be loaded, so you cannot use the arrow keys for line editing and history.");
                writer.flush();
            }
            return null;
        }
    }

    public static void main(String[] asArgs) {
        PrintWriter writer = new PrintWriter(System.out);
        CoherenceQueryLanguage language = new CoherenceQueryLanguage();
        Dependencies deps = DependenciesHelper.newInstance(writer, System.in, language, asArgs);
        if (deps == null) {
            return;
        }
        new QueryPlus(deps).run();
    }

    public static interface Dependencies {
        public CoherenceQueryLanguage getCoherenceQueryLanguage();

        public PrintWriter getOutputWriter();

        public boolean isTraceEnabled();

        public boolean isSanityChecking();

        public boolean isExtendedLanguageEnabled();

        public boolean isExitWhenProcessingComplete();

        public boolean isEcho();

        public List<String> getStatements();

        public List<String> getFiles();

        public boolean isSilent();

        public String getTitle();

        public BufferedReader getReader();

        public StatementExecutor getStatementExecutor();

        public String getGarFileName();

        public String getApplicationName();

        public String[] getDomainPartitions();

        public Duration getTimeout();
    }

    public static class DependenciesHelper {
        public static Dependencies newInstance(PrintWriter writer, InputStream inputStream, CoherenceQueryLanguage language, String[] asArgs) {
            String[] asValidArgs = new String[]{"c", "e", "extend", "help", "f", "l", "s", "t", "trace", "nojline", "g", "a", "dp", "timeout", "jlinedebug", "v"};
            try {
                ListMap map = CommandLineTool.parseArguments(asArgs, asValidArgs, false);
                boolean fExitOnCompletion = map.containsKey("c");
                boolean fSilent = map.containsKey("s");
                BufferedReader reader = null;
                if (map.containsKey("help")) {
                    DependenciesHelper.usage(writer);
                    writer.flush();
                    return null;
                }
                if (!fExitOnCompletion && !map.containsKey("nojline")) {
                    if (map.containsKey("jlinedebug")) {
                        Logger logger = Logger.getLogger("org.jline");
                        logger.setLevel(Level.FINER);
                    }
                    reader = QueryPlus.getJlineReader(System.out, inputStream, fSilent);
                }
                if (reader == null) {
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                }
                DefaultDependencies deps = new DefaultDependencies(writer, reader, language);
                deps.setExitWhenProcessingComplete(fExitOnCompletion);
                deps.setExtendedLanguage(map.containsKey("e") || map.containsKey("extend"));
                if (map.containsKey("f")) {
                    Object oFiles = map.get("f");
                    deps.setFiles(oFiles instanceof List ? (List<String>)oFiles : Collections.singletonList((String)oFiles));
                }
                if (map.containsKey("l")) {
                    Object oStatements = map.get("l");
                    deps.setStatements(oStatements instanceof List ? (List<String>)oStatements : Collections.singletonList((String)oStatements));
                }
                deps.setSilentMode(fSilent);
                deps.setTraceEnabled(map.containsKey("t") || map.containsKey("trace"));
                if (map.containsKey("g")) {
                    deps.setGarFileName((String)map.get("g"));
                    deps.setApplicationName((String)map.get("a"));
                }
                if (map.containsKey("dp")) {
                    String sDomainPartitions = (String)map.get("dp");
                    deps.setDomainPartitions(sDomainPartitions.split(","));
                }
                if (map.containsKey("timeout")) {
                    String sTimeout = (String)map.get("timeout");
                    if (sTimeout.matches("\\d+$")) {
                        deps.setTimeout(new Duration(sTimeout, Duration.Magnitude.MILLI));
                    } else {
                        throw new IllegalArgumentException("Invalid timeout value");
                    }
                }
                if (map.containsKey("v")) {
                    deps.setEcho(true);
                }
                return deps;
            }
            catch (IllegalArgumentException e) {
                DependenciesHelper.usage(writer);
                writer.flush();
                throw e;
            }
        }

        public static void usage(PrintWriter writer) {
            writer.println("java " + QueryPlus.class.getCanonicalName() + " [-t] [-c] [-s] [-e] [-v] [-help] [-l <cmd>]*\n    [-f <file>]* [-g <garFile>] [-a <appName>] [-dp <parition-list>] [-timeout <value>] [-nojline] [-jlinedebug]");
            writer.println("\nCommand Line Arguments:\n-a               the application name to use. Used in combination with the -g\n                 argument.\n-c               exit when command line processing is finished\n-e               or -extend \n                 extended language mode.  Allows object literals in update and\n                 insert statements.\n                 elements between '[' and']'denote an ArrayList.\n                 elements between '{' and'}'denote a HashSet.\n                 elements between '{' and'}'with key/value pairs separated by\n                 ':' denotes a HashMap. A literal HashMap  preceded by a class\n                 name are processed by calling a zero argument constructor then\n                 followed by each pair key being turned into a setter and\n                 invoked with the value.\n-f <value>       Each instance of -f followed by a filename load one file of\n                 statements.\n-g <value>       An optional GAR file to load before running QueryPlus.\n                 If the -a argument is not used the application name will be the\n                 GAR file name without the parent directory name.\n-help            Print command line arguments documention.\n-l <value>       Each instance of -l followed by a statement will execute one\n                 statement.\n-s               silent mode. Suppress prompts and result headings, read from\n                 stdin and write to stdout. Useful for use in pipes or filters\n-t               or -trace \n                 turn on tracing. This shows information useful for debugging\n-dp <list>       A comma delimited list of domain partition names to use.\n                 On start-up the first domain partition in the list will be the\n                 current partition. The -dp argument is only applicable in\n                 combination with the -g argument.\n-timeout <value> Specifies the timeout value for CohQL statements in\n                 milli-seconds.\n-v               verbose mode. Echo each input statement as it is read.\n-nojline         do not use jline console\n-jlinedebug      enable FINER logging to debug jline\n");
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected final CoherenceQueryLanguage f_language;
        protected boolean m_fTraceEnabled;
        protected boolean m_fSanity = false;
        protected boolean m_fExtendedLanguage = false;
        protected final PrintWriter f_writer;
        protected boolean m_fSilent = false;
        protected String m_sTitle = "Results";
        protected boolean m_fExitWhenProcessingComplete;
        protected List<String> m_listStatements = new LinkedList<String>();
        protected List<String> m_listFiles = new LinkedList<String>();
        protected BufferedReader m_reader;
        protected StatementExecutor m_executor = new StatementExecutor();
        protected String m_sGarFileName;
        protected String m_sApplicationName;
        protected String[] m_sDomainPartitions;
        protected Duration m_timeout = new Duration(1, Duration.Magnitude.MINUTE);
        protected boolean m_fEcho = false;

        public DefaultDependencies(PrintWriter writer, BufferedReader reader, CoherenceQueryLanguage language) {
            this.f_writer = writer;
            this.m_reader = reader;
            this.f_language = language;
        }

        @Override
        public CoherenceQueryLanguage getCoherenceQueryLanguage() {
            return this.f_language;
        }

        @Override
        public PrintWriter getOutputWriter() {
            return this.f_writer;
        }

        public void setTraceEnabled(boolean fTraceEnabled) {
            this.m_fTraceEnabled = fTraceEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.m_fTraceEnabled;
        }

        public void setSanityCheckingEnabled(boolean fSanity) {
            this.m_fSanity = fSanity;
        }

        @Override
        public boolean isSanityChecking() {
            return this.m_fSanity;
        }

        public void setEcho(boolean fEcho) {
            this.m_fEcho = fEcho;
        }

        @Override
        public boolean isEcho() {
            return this.m_fEcho;
        }

        public void setExtendedLanguage(boolean fExtendedLanguage) {
            this.m_fExtendedLanguage = fExtendedLanguage;
        }

        @Override
        public boolean isExtendedLanguageEnabled() {
            return this.m_fExtendedLanguage;
        }

        public void setExitWhenProcessingComplete(boolean fExit) {
            this.m_fExitWhenProcessingComplete = fExit;
        }

        @Override
        public boolean isExitWhenProcessingComplete() {
            return this.m_fExitWhenProcessingComplete;
        }

        public void setStatements(List<String> listStatements) {
            this.m_listStatements = listStatements;
        }

        @Override
        public List<String> getStatements() {
            return this.m_listStatements;
        }

        public void setFiles(List<String> listFiles) {
            this.m_listFiles = listFiles;
        }

        @Override
        public List<String> getFiles() {
            return this.m_listFiles;
        }

        @Override
        public boolean isSilent() {
            return this.m_fSilent;
        }

        public void setSilentMode(boolean fSilent) {
            this.m_fSilent = fSilent;
        }

        public void setTitle(String sTitle) {
            this.m_sTitle = sTitle;
        }

        @Override
        public String getTitle() {
            return this.m_sTitle;
        }

        @Override
        public BufferedReader getReader() {
            return this.m_reader;
        }

        public void setStatementExecutor(StatementExecutor executor) {
            Base.azzert(executor != null);
            this.m_executor = executor;
        }

        @Override
        public StatementExecutor getStatementExecutor() {
            return this.m_executor;
        }

        public void setGarFileName(String sGarFile) {
            this.m_sGarFileName = sGarFile;
        }

        @Override
        public String getGarFileName() {
            return this.m_sGarFileName;
        }

        public void setApplicationName(String sApplicationName) {
            this.m_sApplicationName = sApplicationName;
        }

        @Override
        public String getApplicationName() {
            return this.m_sApplicationName;
        }

        public void setDomainPartitions(String[] asDomainPartitions) {
            this.m_sDomainPartitions = asDomainPartitions;
        }

        @Override
        public String[] getDomainPartitions() {
            return this.m_sDomainPartitions;
        }

        public void setTimeout(Duration timeout) {
            this.m_timeout = timeout;
        }

        @Override
        public Duration getTimeout() {
            return this.m_timeout;
        }
    }
}

