/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExtractorBuilder;
import com.tangosol.coherence.dslquery.internal.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dslquery.internal.ConstructorQueryWalker;
import com.tangosol.coherence.dslquery.operator.BaseOperator;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FilterBuilder
extends AbstractCoherenceQueryWalker {
    protected Term m_term;
    protected String m_sCacheName;
    protected final List f_listDefaultBindVars;
    protected final ParameterResolver f_defaultNamedBindVars;

    public FilterBuilder() {
        this(Collections.emptyList(), new NullParameterResolver(), new CoherenceQueryLanguage());
    }

    public FilterBuilder(CoherenceQueryLanguage language) {
        this(Collections.emptyList(), new NullParameterResolver(), language);
    }

    public FilterBuilder(Object[] aoBindVars) {
        this(Arrays.asList(aoBindVars), new NullParameterResolver(), new CoherenceQueryLanguage());
    }

    public FilterBuilder(Term term) {
        this();
        this.m_term = term;
    }

    public FilterBuilder(Object[] aoBindVars, Map mapNamedBindVars) {
        this(Arrays.asList(aoBindVars), new ResolvableParameterList(FilterBuilder.newParameterListFromMap(mapNamedBindVars)), new CoherenceQueryLanguage());
    }

    public FilterBuilder(List indexedBindVars, ParameterResolver namedBindVars, CoherenceQueryLanguage language) {
        super(indexedBindVars, namedBindVars, language);
        this.f_listDefaultBindVars = this.m_listBindVars;
        this.f_defaultNamedBindVars = this.m_namedBindVars;
    }

    public Filter makeFilter() {
        return this.makeFilter(this.m_term, this.f_listDefaultBindVars, this.f_defaultNamedBindVars);
    }

    public Filter makeFilter(Term term) {
        return this.makeFilter(term, this.f_listDefaultBindVars, this.f_defaultNamedBindVars);
    }

    public Filter makeFilter(Term term, Object[] aoIndexedBindVars) {
        return this.makeFilter(term, Arrays.asList(aoIndexedBindVars), this.f_defaultNamedBindVars);
    }

    public Filter makeFilter(Term term, Object[] aoIndexedBindVars, Map mapNamedBindVars) {
        return this.makeFilter(term, Arrays.asList(aoIndexedBindVars), new ResolvableParameterList(mapNamedBindVars));
    }

    public Filter makeFilter(Term term, List listBindVars, ParameterResolver namedBindVars) {
        return this.makeFilterForCache(null, term, listBindVars, namedBindVars);
    }

    public Filter makeFilterForCache(String sCacheName, Term term, List indexedBindVars, ParameterResolver namedBindVars) {
        this.m_sCacheName = sCacheName;
        this.m_term = term;
        this.m_listBindVars = indexedBindVars == null ? this.f_listDefaultBindVars : indexedBindVars;
        this.m_namedBindVars = namedBindVars == null ? this.f_defaultNamedBindVars : namedBindVars;
        this.setResult(null);
        this.m_term.accept(this);
        Object oResult = this.getResult();
        if (oResult instanceof Filter) {
            return (Filter)oResult;
        }
        if (oResult instanceof Boolean) {
            return (Boolean)oResult != false ? AlwaysFilter.INSTANCE : NeverFilter.INSTANCE;
        }
        throw new RuntimeException("Filter not specified. " + String.valueOf(oResult) + " Found instead!");
    }

    public ValueExtractor makeExtractor(NodeTerm term) {
        this.m_term = term;
        this.setResult(null);
        term.accept(this);
        return (ValueExtractor)this.getResult();
    }

    @Override
    protected void acceptList(NodeTerm termList) {
        int cTerms = termList.length();
        Object[] ao = new Object[cTerms];
        for (int i = 1; i <= cTerms; ++i) {
            termList.termAt(i).accept(this);
            ao[i - 1] = this.getResult();
        }
        this.setResult(ao);
    }

    @Override
    protected void acceptIdentifier(String sIdentifier) {
        if (this.acceptIdentifierInternal(sIdentifier)) {
            return;
        }
        ExtractorBuilder builder = this.f_language.getExtractorBuilder();
        this.setResult(builder.realize(this.m_sCacheName, 0, sIdentifier));
    }

    @Override
    protected void acceptBinaryOperator(String sOperator, Term termLeft, Term termRight) {
        BaseOperator operator = this.f_language.getOperator(sOperator);
        if (operator == null) {
            throw new RuntimeException("Cannot build filter from unknown operator " + sOperator);
        }
        if (operator.isConditional()) {
            this.setResult(operator.makeFilter(termLeft, termRight, this));
        } else {
            this.setResult(operator.makeExtractor(termLeft, termRight, this));
        }
    }

    @Override
    protected void acceptUnaryOperator(String sOperator, Term t) {
        switch (sOperator) {
            case "new": {
                ConstructorQueryWalker walker = new ConstructorQueryWalker(this.m_listBindVars, this.m_namedBindVars, this.f_language);
                t.accept(walker);
                this.setResult(this.reflectiveMakeObject(true, walker.getResult()));
                break;
            }
            case "!": {
                t.accept(this);
                NotFilter filter = new NotFilter((Filter)this.getResult());
                this.setResult(filter);
                break;
            }
            case "-": {
                t.accept(this);
                AtomicTerm atomicTerm = this.m_atomicTerm;
                if (!atomicTerm.isNumber()) break;
                Number number = atomicTerm.negativeNumber((Number)this.getResult());
                this.setResult(number);
                break;
            }
            case "+": {
                t.accept(this);
                break;
            }
            default: {
                this.setResult(null);
            }
        }
    }

    @Override
    protected void acceptPath(NodeTerm term) {
        this.acceptPathAsChainedExtractor(this.m_sCacheName, term);
    }

    protected static ParameterList newParameterListFromMap(Map<?, ?> map) {
        SimpleParameterList list = new SimpleParameterList();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            list.add(new Parameter(String.valueOf(entry.getKey()), entry.getValue()));
        }
        return list;
    }
}

