/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.StatementExecutor;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Session;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;

public class ExecutionContext {
    protected final ResourceRegistry f_resourceRegistry;
    protected ConfigurableCacheFactory m_cacheFactory;
    protected Session m_session;
    protected Cluster m_cluster;
    protected boolean m_fTrace;
    protected boolean m_fSanity = true;
    protected boolean m_fExtendedLanguage = false;
    protected CoherenceQueryLanguage m_language;
    protected PrintWriter m_writer;
    protected boolean m_fStopOnError = false;
    protected String m_sTitle = "Results";
    protected StatementExecutor m_executor = new StatementExecutor();
    protected boolean m_fSilent = false;
    protected BufferedReader m_reader;
    protected Duration m_timeout = new Duration(Long.MAX_VALUE);

    public ExecutionContext() {
        this.f_resourceRegistry = new SimpleResourceRegistry();
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_resourceRegistry;
    }

    @Deprecated
    public void setCacheFactory(ConfigurableCacheFactory ccf) {
        this.m_cacheFactory = ccf;
        this.m_session = new ConfigurableCacheFactorySession(ccf, null);
    }

    @Deprecated
    public ConfigurableCacheFactory getCacheFactory() {
        ConfigurableCacheFactory cacheFactory = this.m_cacheFactory;
        if (cacheFactory == null) {
            Session session = this.m_session;
            if (session == null) {
                cacheFactory = CacheFactory.getConfigurableCacheFactory();
                this.m_session = new ConfigurableCacheFactorySession(cacheFactory, Base.getContextClassLoader());
            } else if (session instanceof ConfigurableCacheFactorySession) {
                cacheFactory = ((ConfigurableCacheFactorySession)session).getConfigurableCacheFactory();
            } else {
                throw new IllegalStateException("No CacheFactory available");
            }
            this.m_cacheFactory = cacheFactory;
        }
        return cacheFactory;
    }

    public Session getSession() {
        Session session = this.m_session;
        if (session == null) {
            ConfigurableCacheFactory cacheFactory = this.m_cacheFactory;
            if (cacheFactory == null) {
                this.m_cacheFactory = cacheFactory = CacheFactory.getConfigurableCacheFactory();
            }
            this.m_session = session = new ConfigurableCacheFactorySession(cacheFactory, Base.getContextClassLoader());
        }
        return session;
    }

    public void setSession(Session session) {
        this.m_session = session;
        if (session instanceof ConfigurableCacheFactorySession) {
            this.m_cacheFactory = ((ConfigurableCacheFactorySession)session).getConfigurableCacheFactory();
        }
    }

    public void setCluster(Cluster cluster) {
        this.m_cluster = cluster;
    }

    public Cluster getCluster() {
        if (this.m_cluster == null) {
            this.m_cluster = CacheFactory.ensureCluster();
        }
        return this.m_cluster;
    }

    public void setCoherenceQueryLanguage(CoherenceQueryLanguage language) {
        this.m_language = language;
    }

    public CoherenceQueryLanguage getCoherenceQueryLanguage() {
        return this.m_language;
    }

    public void setTraceEnabled(boolean fTrace) {
        this.m_fTrace = fTrace;
    }

    public boolean isTraceEnabled() {
        return this.m_fTrace;
    }

    public void setSanityCheckingEnabled(boolean fSanity) {
        this.m_fSanity = fSanity;
    }

    public boolean isSanityChecking() {
        return this.m_fSanity;
    }

    public void setExtendedLanguage(boolean fExtendedLanguage) {
        this.m_fExtendedLanguage = fExtendedLanguage;
    }

    public boolean isExtendedLanguageEnabled() {
        return this.m_fExtendedLanguage;
    }

    public void setWriter(PrintWriter writer) {
        this.m_writer = writer;
    }

    public PrintWriter getWriter() {
        return this.m_writer;
    }

    public boolean isStopOnError() {
        return this.m_fStopOnError;
    }

    public void setStopOnError(boolean fStopOnError) {
        this.m_fStopOnError = fStopOnError;
    }

    public void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public String getTitle() {
        return this.m_sTitle;
    }

    public void setStatementExecutor(StatementExecutor executor) {
        Base.azzert(executor != null);
        this.m_executor = executor;
    }

    public StatementExecutor getStatementExecutor() {
        return this.m_executor;
    }

    public OPParser instantiateParser(Reader reader) {
        TokenTable tokenTable = this.m_fExtendedLanguage ? this.m_language.extendedSqlTokenTable() : this.m_language.sqlTokenTable();
        return new OPParser(reader, tokenTable, this.m_language.getOperators());
    }

    public boolean isSilent() {
        return this.m_fSilent;
    }

    public void setSilentMode(boolean fSilent) {
        this.m_fSilent = fSilent;
    }

    public BufferedReader getReader() {
        return this.m_reader;
    }

    public void setReader(BufferedReader reader) {
        this.m_reader = reader;
    }

    public Duration getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("Timeout duration cannot be null");
        }
        this.m_timeout = timeout;
    }
}

