/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.ExtractorBuilder;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dslquery.StatementBuilder;
import com.tangosol.coherence.dslquery.UniversalExtractorBuilder;
import com.tangosol.coherence.dslquery.function.FunctionBuilders;
import com.tangosol.coherence.dslquery.operator.AdditionOperator;
import com.tangosol.coherence.dslquery.operator.AndOperator;
import com.tangosol.coherence.dslquery.operator.BaseOperator;
import com.tangosol.coherence.dslquery.operator.BetweenOperator;
import com.tangosol.coherence.dslquery.operator.ContainsAllOperator;
import com.tangosol.coherence.dslquery.operator.ContainsAnyOperator;
import com.tangosol.coherence.dslquery.operator.ContainsOperator;
import com.tangosol.coherence.dslquery.operator.DivisionOperator;
import com.tangosol.coherence.dslquery.operator.EqualsOperator;
import com.tangosol.coherence.dslquery.operator.GreaterEqualsOperator;
import com.tangosol.coherence.dslquery.operator.GreaterOperator;
import com.tangosol.coherence.dslquery.operator.ILikeOperator;
import com.tangosol.coherence.dslquery.operator.InOperator;
import com.tangosol.coherence.dslquery.operator.LessEqualsOperator;
import com.tangosol.coherence.dslquery.operator.LessOperator;
import com.tangosol.coherence.dslquery.operator.LikeOperator;
import com.tangosol.coherence.dslquery.operator.MultiplicationOperator;
import com.tangosol.coherence.dslquery.operator.NotEqualsOperator;
import com.tangosol.coherence.dslquery.operator.OrOperator;
import com.tangosol.coherence.dslquery.operator.SubtractionOperator;
import com.tangosol.coherence.dslquery.operator.XorOperator;
import com.tangosol.coherence.dslquery.statement.BackupStatementBuilder;
import com.tangosol.coherence.dslquery.statement.CreateCacheStatementBuilder;
import com.tangosol.coherence.dslquery.statement.CreateIndexStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DeleteStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DropCacheStatementBuilder;
import com.tangosol.coherence.dslquery.statement.DropIndexStatementBuilder;
import com.tangosol.coherence.dslquery.statement.InsertStatementBuilder;
import com.tangosol.coherence.dslquery.statement.QueryRecorderStatementBuilder;
import com.tangosol.coherence.dslquery.statement.RestoreStatementBuilder;
import com.tangosol.coherence.dslquery.statement.SelectStatementBuilder;
import com.tangosol.coherence.dslquery.statement.SourceStatementBuilder;
import com.tangosol.coherence.dslquery.statement.TruncateCacheStatementBuilder;
import com.tangosol.coherence.dslquery.statement.UpdateStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ArchiveSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.CreateSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ForceRecoveryStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ListArchiverStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ListServicesStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ListSnapshotsStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.RecoverSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.RemoveSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ResumeServiceStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.RetrieveSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.SuspendServiceStatementBuilder;
import com.tangosol.coherence.dslquery.statement.persistence.ValidateSnapshotStatementBuilder;
import com.tangosol.coherence.dslquery.token.SQLBackupOPToken;
import com.tangosol.coherence.dslquery.token.SQLCreateCacheOPToken;
import com.tangosol.coherence.dslquery.token.SQLCreateIndexOPToken;
import com.tangosol.coherence.dslquery.token.SQLDeleteOPToken;
import com.tangosol.coherence.dslquery.token.SQLDropCacheOPToken;
import com.tangosol.coherence.dslquery.token.SQLDropIndexOPToken;
import com.tangosol.coherence.dslquery.token.SQLExplainOPToken;
import com.tangosol.coherence.dslquery.token.SQLInsertOPToken;
import com.tangosol.coherence.dslquery.token.SQLPeekOPToken;
import com.tangosol.coherence.dslquery.token.SQLRestoreOPToken;
import com.tangosol.coherence.dslquery.token.SQLSelectOPToken;
import com.tangosol.coherence.dslquery.token.SQLSourceOPToken;
import com.tangosol.coherence.dslquery.token.SQLTraceOPToken;
import com.tangosol.coherence.dslquery.token.SQLTruncateCacheOPToken;
import com.tangosol.coherence.dslquery.token.SQLUpdateOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLArchiveSnapshotOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLCreateSnapshotOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLForceRecoveryOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLListArchivedSnapshotsOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLListArchiverOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLListServicesOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLListSnapshotsOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLRecoverSnapshotOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLRemoveSnapshotOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLResumeServiceOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLRetrieveSnapshotOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLSuspendServiceOPToken;
import com.tangosol.coherence.dslquery.token.persistence.SQLValidateSnapshotOPToken;
import com.tangosol.coherence.dsltools.base.LiteralBaseToken;
import com.tangosol.coherence.dsltools.precedence.EndOfStatementOPToken;
import com.tangosol.coherence.dsltools.precedence.InfixRightOPToken;
import com.tangosol.coherence.dsltools.precedence.KeywordOPToken;
import com.tangosol.coherence.dsltools.precedence.ListOpToken;
import com.tangosol.coherence.dsltools.precedence.LiteralOPToken;
import com.tangosol.coherence.dsltools.precedence.NotOPToken;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import com.tangosol.coherence.dsltools.precedence.ParenOPToken;
import com.tangosol.coherence.dsltools.precedence.PathOPToken;
import com.tangosol.coherence.dsltools.precedence.PrefixOPToken;
import com.tangosol.coherence.dsltools.precedence.PunctuationOPToken;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termlanguage.ColonToken;
import com.tangosol.coherence.dsltools.termlanguage.CurlyToken;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.config.expression.ParameterResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CoherenceQueryLanguage {
    protected TokenTable m_tokenTableForFilter;
    protected TokenTable m_tokenTableSQL;
    protected TokenTable m_tokenTableExtendedSQL;
    protected Map<String, ParameterizedBuilder<?>> m_mapFunctions;
    protected Map<CharSequence, BaseOperator> m_mapOperators;
    protected Map<String, StatementBuilder<?>> m_mapStatementBuilders;
    protected ExtractorBuilder m_bldrExtractor = new UniversalExtractorBuilder();

    public CoherenceQueryLanguage() {
        this.m_tokenTableSQL = this.getSqlTokenTable(false);
        this.m_tokenTableExtendedSQL = this.getSqlTokenTable(true);
        this.m_tokenTableForFilter = this.createCommonTokens();
        this.m_mapOperators = this.initializeOperatorMap();
        this.m_mapFunctions = this.initializeFunctionMap();
        this.m_mapStatementBuilders = this.createStatements();
    }

    public TokenTable filtersTokenTable() {
        return this.m_tokenTableForFilter;
    }

    public TokenTable sqlTokenTable() {
        return this.m_tokenTableSQL;
    }

    public TokenTable extendedSqlTokenTable() {
        return this.m_tokenTableExtendedSQL;
    }

    protected TokenTable getSqlTokenTable(boolean fExtended) {
        TokenTable tokens = this.createCommonTokens();
        tokens.addToken(new SQLPeekOPToken("alter", new OPToken[0]));
        tokens.addToken(new SQLBackupOPToken("backup"));
        tokens.addToken(new SQLPeekOPToken("create", new SQLCreateCacheOPToken(), new SQLCreateIndexOPToken(), new SQLCreateSnapshotOPToken()));
        tokens.alias("ensure", "create");
        tokens.addToken(new SQLDeleteOPToken("delete"));
        tokens.addToken(new SQLPeekOPToken("drop", new SQLDropCacheOPToken(), new SQLDropIndexOPToken()));
        tokens.addToken(new SQLTruncateCacheOPToken("truncate"));
        tokens.addToken(new SQLExplainOPToken("explain"));
        tokens.addToken(new SQLInsertOPToken("insert"));
        tokens.addToken(new SQLRestoreOPToken("restore"));
        tokens.addToken(new SQLSelectOPToken("select"));
        tokens.addToken(new SQLSourceOPToken("@"));
        tokens.alias("source", "@");
        tokens.addToken(new SQLTraceOPToken("trace"));
        tokens.addToken(new SQLUpdateOPToken("update"));
        tokens.addToken(new SQLPeekOPToken("list", new SQLListServicesOPToken(), new SQLListSnapshotsOPToken(), new SQLListArchivedSnapshotsOPToken(), new SQLListArchiverOPToken()));
        tokens.addToken(new SQLRemoveSnapshotOPToken("remove"));
        tokens.addToken(new SQLRecoverSnapshotOPToken("recover"));
        tokens.addToken(new SQLValidateSnapshotOPToken("validate"));
        tokens.addToken(new SQLArchiveSnapshotOPToken("archive"));
        tokens.addToken(new SQLRetrieveSnapshotOPToken("retrieve"));
        tokens.addToken(new SQLResumeServiceOPToken("resume"));
        tokens.addToken(new SQLSuspendServiceOPToken("suspend"));
        tokens.addToken(new SQLForceRecoveryOPToken("force"));
        tokens.addToken(new KeywordOPToken("by"));
        tokens.addToken(new KeywordOPToken("cache"));
        tokens.addToken(new KeywordOPToken("check"));
        tokens.addToken(new KeywordOPToken("distinct"));
        tokens.addToken(new KeywordOPToken("escape"));
        tokens.addToken(new KeywordOPToken("file"));
        tokens.addToken(new KeywordOPToken("from"));
        tokens.addToken(new KeywordOPToken("group"));
        tokens.addToken(new KeywordOPToken("having"));
        tokens.addToken(new KeywordOPToken("index"));
        tokens.addToken(new KeywordOPToken("into"));
        tokens.addToken(new KeywordOPToken("key"));
        tokens.addToken(new KeywordOPToken("off"));
        tokens.addToken(new KeywordOPToken("on"));
        tokens.addToken(new KeywordOPToken("order"));
        tokens.addToken(new KeywordOPToken("plan"));
        tokens.addToken(new KeywordOPToken("service"));
        tokens.addToken(new KeywordOPToken("set"));
        tokens.addToken(new KeywordOPToken("show"));
        tokens.addToken(new KeywordOPToken("to"));
        tokens.addToken(new KeywordOPToken("value"));
        tokens.addToken(new KeywordOPToken("where"));
        if (fExtended) {
            tokens.addToken(new ListOpToken("[", 80, ".list."));
            tokens.addToken(new CurlyToken("{", 80));
            tokens.addToken(new ColonToken(":", 80));
        }
        return tokens;
    }

    private TokenTable createCommonTokens() {
        TokenTable tokenTable = new TokenTable(OPToken.IDENTIFIER_NODE, OPToken.LITERAL_NODE);
        tokenTable.setIgnoreCase(true);
        tokenTable.addToken(new InfixRightOPToken("**", 61, OPToken.BINARY_OPERATOR_NODE));
        tokenTable.addToken(new NotOPToken("!", 75, OPToken.UNARY_OPERATOR_NODE, OPToken.UNARY_OPERATOR_NODE));
        tokenTable.addToken(new PrefixOPToken("new", 75, OPToken.UNARY_OPERATOR_NODE));
        tokenTable.addToken(new PrefixOPToken("~", 75, OPToken.UNARY_OPERATOR_NODE));
        tokenTable.addToken(new PrefixOPToken("?", 75, OPToken.BINDING_NODE));
        tokenTable.addToken(new PrefixOPToken(":", 75, OPToken.BINDING_NODE));
        tokenTable.addToken(new ParenOPToken("(", 80, OPToken.CALL_NODE, OPToken.LIST_NODE));
        tokenTable.addToken(new PathOPToken(".", 80, OPToken.DEREF_NODE));
        tokenTable.addToken(new PunctuationOPToken(","));
        tokenTable.addToken(EndOfStatementOPToken.INSTANCE);
        tokenTable.addToken("true", new LiteralOPToken(LiteralBaseToken.createBoolean("true")), null, OPToken.LITERAL_NODE);
        tokenTable.addToken("false", new LiteralOPToken(LiteralBaseToken.createBoolean("false")), null, OPToken.LITERAL_NODE);
        tokenTable.addToken("null", new LiteralOPToken(LiteralBaseToken.createNull("null")), null, OPToken.LITERAL_NODE);
        tokenTable.addToken("nan", new LiteralOPToken(LiteralBaseToken.createDouble("NaN")), null, OPToken.LITERAL_NODE);
        tokenTable.addToken("infinity", new LiteralOPToken(LiteralBaseToken.createDouble("Infinity")), null, OPToken.LITERAL_NODE);
        tokenTable.alias("not", "!");
        if (this.m_mapOperators != null) {
            for (BaseOperator op : this.m_mapOperators.values()) {
                op.addToTokenTable(tokenTable);
            }
        }
        return tokenTable;
    }

    protected Map<String, ParameterizedBuilder<?>> initializeFunctionMap() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        map.put("max", FunctionBuilders.DOUBLE_MAX_FUNCTION_BUILDER);
        map.put("min", FunctionBuilders.DOUBLE_MIN_FUNCTION_BUILDER);
        map.put("sum", FunctionBuilders.DOUBLE_SUM_FUNCTION_BUILDER);
        map.put("avg", FunctionBuilders.DOUBLE_AVERAGE_FUNCTION_BUILDER);
        map.put("bd_max", FunctionBuilders.BIG_DECIMAL_MAX_FUNCTION_BUILDER);
        map.put("bd_min", FunctionBuilders.BIG_DECIMAL_MIN_FUNCTION_BUILDER);
        map.put("bd_sum", FunctionBuilders.BIG_DECIMAL_SUM_FUNCTION_BUILDER);
        map.put("bd_avg", FunctionBuilders.BIG_DECIMAL_AVERAGE_FUNCTION_BUILDER);
        map.put("long_max", FunctionBuilders.LONG_MAX_FUNCTION_BUILDER);
        map.put("long_min", FunctionBuilders.LONG_MIN_FUNCTION_BUILDER);
        map.put("long_sum", FunctionBuilders.LONG_SUM_FUNCTION_BUILDER);
        map.put("count", FunctionBuilders.COUNT_FUNCTION_BUILDER);
        map.put("value", FunctionBuilders.VALUE_FUNCTION_BUILDER);
        map.put("key", FunctionBuilders.KEY_FUNCTION_BUILDER);
        map.put("concat", FunctionBuilders.CONCAT_FUNCTION_BUILDER);
        return map;
    }

    public ParameterizedBuilder getFunction(String sName) {
        return this.m_mapFunctions.get(this.getFunctionKey(sName));
    }

    public void addFunction(String sName, ParameterizedBuilder bldrFunction) {
        if (sName == null || bldrFunction == null) {
            throw new IllegalArgumentException("Both name and function must be supplied to add a function");
        }
        this.m_mapFunctions.put(this.getFunctionKey(sName), bldrFunction);
    }

    public ParameterizedBuilder<?> removeFunction(String sName) {
        return this.m_mapFunctions.remove(this.getFunctionKey(sName));
    }

    public synchronized void clearCustomFunctions() {
        this.m_mapFunctions = null;
        this.initializeFunctionMap();
    }

    protected Map<CharSequence, BaseOperator> initializeOperatorMap() {
        this.m_mapOperators = new HashMap<CharSequence, BaseOperator>();
        HashMap<CharSequence, BaseOperator> map = this.m_mapOperators;
        this.addOperatorInternal(map, AndOperator.INSTANCE);
        this.addOperatorInternal(map, BetweenOperator.INSTANCE);
        this.addOperatorInternal(map, ContainsAllOperator.INSTANCE);
        this.addOperatorInternal(map, ContainsAnyOperator.INSTANCE);
        this.addOperatorInternal(map, ContainsOperator.INSTANCE);
        this.addOperatorInternal(map, EqualsOperator.INSTANCE);
        this.addOperatorInternal(map, GreaterEqualsOperator.INSTANCE);
        this.addOperatorInternal(map, GreaterOperator.INSTANCE);
        this.addOperatorInternal(map, InOperator.INSTANCE);
        this.addOperatorInternal(map, LessEqualsOperator.INSTANCE);
        this.addOperatorInternal(map, LessOperator.INSTANCE);
        this.addOperatorInternal(map, LikeOperator.INSTANCE);
        this.addOperatorInternal(map, ILikeOperator.INSTANCE);
        this.addOperatorInternal(map, NotEqualsOperator.INSTANCE);
        this.addOperatorInternal(map, OrOperator.INSTANCE);
        this.addOperatorInternal(map, XorOperator.INSTANCE);
        this.addOperatorInternal(map, AdditionOperator.INSTANCE);
        this.addOperatorInternal(map, SubtractionOperator.INSTANCE);
        this.addOperatorInternal(map, MultiplicationOperator.INSTANCE);
        this.addOperatorInternal(map, DivisionOperator.INSTANCE);
        return map;
    }

    private void addOperatorInternal(Map<CharSequence, BaseOperator> map, BaseOperator op) {
        map.put(op.getSymbol(), op);
        TokenTable tokenTable = this.m_tokenTableForFilter;
        if (tokenTable != null) {
            op.addToTokenTable(tokenTable);
        }
        if ((tokenTable = this.m_tokenTableSQL) != null) {
            op.addToTokenTable(tokenTable);
        }
        if ((tokenTable = this.m_tokenTableExtendedSQL) != null) {
            op.addToTokenTable(tokenTable);
        }
    }

    public void addOperator(BaseOperator operator) {
        this.addOperatorInternal(this.m_mapOperators, operator);
    }

    public Set<CharSequence> getOperators() {
        return Collections.unmodifiableSet(this.m_mapOperators.keySet());
    }

    public BaseOperator getOperator(String sSymbol) {
        return this.m_mapOperators.get(sSymbol);
    }

    public Map<String, StatementBuilder<?>> getStatementBuilders() {
        return Collections.unmodifiableMap(this.m_mapStatementBuilders);
    }

    protected Map<String, StatementBuilder<?>> createStatements() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("sqlCreateCacheNode", CreateCacheStatementBuilder.INSTANCE);
        map.put("sqlCreateIndexNode", CreateIndexStatementBuilder.INSTANCE);
        map.put("sqlDropCacheNode", DropCacheStatementBuilder.INSTANCE);
        map.put("sqlTruncateCacheNode", TruncateCacheStatementBuilder.INSTANCE);
        map.put("sqlDropIndexNode", DropIndexStatementBuilder.INSTANCE);
        map.put("sqlBackupCacheNode", BackupStatementBuilder.INSTANCE);
        map.put("sqlRestoreCacheNode", RestoreStatementBuilder.INSTANCE);
        map.put("sqlInsertNode", InsertStatementBuilder.INSTANCE);
        map.put("sqlDeleteNode", DeleteStatementBuilder.INSTANCE);
        map.put("sqlUpdateNode", UpdateStatementBuilder.INSTANCE);
        map.put("sqlSelectNode", SelectStatementBuilder.INSTANCE);
        map.put("sqlSourceNode", SourceStatementBuilder.INSTANCE);
        map.put("sqlExplainNode", QueryRecorderStatementBuilder.EXPLAIN_INSTANCE);
        map.put("sqlTraceNode", QueryRecorderStatementBuilder.TRACE_INSTANCE);
        map.put("sqlListServices", ListServicesStatementBuilder.INSTANCE);
        map.put("sqlListSnapshots", ListSnapshotsStatementBuilder.INSTANCE);
        map.put("sqlListArchiver", ListArchiverStatementBuilder.INSTANCE);
        map.put("sqlCreateSnapshot", CreateSnapshotStatementBuilder.INSTANCE);
        map.put("sqlRecoverSnapshot", RecoverSnapshotStatementBuilder.INSTANCE);
        map.put("sqlRemoveSnapshot", RemoveSnapshotStatementBuilder.INSTANCE);
        map.put("sqlValidateSnapshot", ValidateSnapshotStatementBuilder.INSTANCE);
        map.put("sqlArchiveSnapshot", ArchiveSnapshotStatementBuilder.INSTANCE);
        map.put("sqlRetrieveSnapshot", RetrieveSnapshotStatementBuilder.INSTANCE);
        map.put("sqlResumeService", ResumeServiceStatementBuilder.INSTANCE);
        map.put("sqlSuspendService", SuspendServiceStatementBuilder.INSTANCE);
        map.put("sqlForceRecovery", ForceRecoveryStatementBuilder.INSTANCE);
        return map;
    }

    public StatementBuilder<?> getStatementBuilder(String sFunctor) {
        return this.m_mapStatementBuilders.get(sFunctor);
    }

    public Statement prepareStatement(NodeTerm term, ExecutionContext context, List listBindVars, ParameterResolver namedBindVars) {
        StatementBuilder<?> bldrStatement = this.getStatementBuilder(term.getFunctor());
        if (bldrStatement == null) {
            throw new CohQLException("Unknown translation tree: " + term.getFunctor());
        }
        return bldrStatement.realize(context, term, listBindVars, namedBindVars);
    }

    public void addStatement(String sFunctor, StatementBuilder<?> builder) {
        this.m_mapStatementBuilders.put(sFunctor, builder);
    }

    public StatementBuilder<?> removeStatementBuilder(String sFunctor) {
        return this.m_mapStatementBuilders.remove(sFunctor);
    }

    public void clearCustomOperators() {
        this.m_tokenTableSQL = null;
        this.m_tokenTableExtendedSQL = null;
        this.m_tokenTableForFilter = null;
        this.m_mapOperators = null;
        this.m_mapStatementBuilders = null;
    }

    public void setExtractorBuilder(ExtractorBuilder builder) {
        this.m_bldrExtractor = builder == null ? new UniversalExtractorBuilder() : builder;
    }

    public ExtractorBuilder getExtractorBuilder() {
        return this.m_bldrExtractor;
    }

    protected String getFunctionKey(String sFunctionName) {
        Objects.requireNonNull(sFunctionName);
        return this.getSqlTokenTable(false).isIgnoringCase() ? sFunctionName.toLowerCase() : sFunctionName;
    }
}

