/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.FlashJournalScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.RamJournalScheme;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="storage")
public class StorageProcessor
implements ElementProcessor<CachingScheme> {
    @Override
    public CachingScheme process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        String sValue = (String)xmlElement.getValue();
        UnitCalculatorBuilder bldr = this.getUnitCalculatorBuilder(context.getDefaultParameterResolver());
        if (sValue == null || "on-heap".equals(sValue)) {
            LocalScheme scheme = new LocalScheme();
            scheme.setUnitCalculatorBuilder(bldr);
            return scheme;
        }
        if ("flashjournal".equals(sValue)) {
            FlashJournalScheme scheme = new FlashJournalScheme();
            scheme.setUnitCalculatorBuilder(bldr);
            return scheme;
        }
        if ("ramjournal".equals(sValue)) {
            RamJournalScheme scheme = new RamJournalScheme();
            scheme.setUnitCalculatorBuilder(bldr);
            return scheme;
        }
        XmlElement xmlParent = xmlElement.getParent();
        String sParent = xmlParent != null ? "<" + xmlParent.getName() + ">" : "";
        throw new ConfigurationException("invalid value " + sValue + " for " + sParent + "<storage> element", "Provide a valid value of \"on-heap\", \"flashjournal\" or \"ramjournal\"");
    }

    private UnitCalculatorBuilder getUnitCalculatorBuilder(ParameterResolver resolver) {
        UnitCalculatorBuilder bldr = new UnitCalculatorBuilder();
        Parameter parm = resolver.resolve("unit-calculator");
        LiteralExpression<String> expr = parm == null ? new LiteralExpression<String>("BINARY") : parm.evaluate(resolver).as(Expression.class);
        bldr.setUnitCalculatorType(expr);
        return bldr;
    }
}

