/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.SSLSocketProviderDependenciesBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.ssl.SSLSocketProviderDefaultDependencies;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.TcpDatagramSocketProvider;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;

@XmlSimpleName(value="socket-provider")
public class SocketProviderProcessor
implements ElementProcessor<SocketProviderBuilder> {
    @Override
    public SocketProviderBuilder process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        String sId = SocketProviderProcessor.getProviderDefinitionId(xmlElement);
        boolean fInlinedProvider = "".equals(sId);
        SocketProviderFactory factory = SocketProviderFactory.getSocketProviderFactory(context, xmlElement);
        SocketProviderFactory.DefaultDependencies deps = (SocketProviderFactory.DefaultDependencies)factory.getDependencies();
        if (XmlHelper.isEmpty(xmlElement)) {
            return factory.getDefaultSocketProviderBuilder();
        }
        if (fInlinedProvider) {
            String sName = SocketProviderProcessor.getProviderIdReference(xmlElement);
            if (sName != null && sName.length() > 0) {
                return new SocketProviderBuilder(sName, factory.getDependencies(), false);
            }
            deps = new SocketProviderFactory.DefaultDependencies();
            deps.setSocketProviderFactory(factory);
        }
        for (XmlElement xmlProvider : xmlElement.getElementList()) {
            String sType = xmlProvider.getName();
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SYSTEM.getName())) {
                deps.addNamedProviderType(sId, SocketProviderFactory.Dependencies.ProviderType.SYSTEM);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.TCP.getName())) {
                deps.addNamedProviderType(sId, SocketProviderFactory.Dependencies.ProviderType.TCP);
                XmlElement xmlCat = xmlElement.getSafeElement("datagram-socket");
                TcpDatagramSocketProvider.DefaultDependencies depsDatagram = new TcpDatagramSocketProvider.DefaultDependencies();
                context.inject(depsDatagram, xmlCat);
                deps.addNamedTCPDatagramDependencies(sId, depsDatagram);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SSL.getName())) {
                deps.addNamedProviderType(sId, SocketProviderFactory.Dependencies.ProviderType.SSL);
                SSLSocketProviderDefaultDependencies depsSSL = new SSLSocketProviderDefaultDependencies(deps);
                context.addCookie(SSLSocketProviderDefaultDependencies.class, depsSSL);
                SSLSocketProviderDependenciesBuilder builder = new SSLSocketProviderDependenciesBuilder(depsSSL);
                context.inject(builder, xmlProvider);
                deps.addNamedSSLDependenciesBuilder(sId, builder);
                XmlElement xmlCat = xmlProvider.getElement("datagram-socket");
                if (xmlCat == null) continue;
                TcpDatagramSocketProvider.DefaultDependencies dependencies = new TcpDatagramSocketProvider.DefaultDependencies();
                context.inject(dependencies, xmlCat);
                deps.addNamedTCPDatagramDependencies(sId, dependencies);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.SDP.getName())) {
                deps.addNamedProviderType(sId, SocketProviderFactory.Dependencies.ProviderType.SDP);
                continue;
            }
            if (sType.equals(SocketProviderFactory.Dependencies.ProviderType.GRPC.getName())) {
                deps.addNamedProviderType(sId, SocketProviderFactory.Dependencies.ProviderType.GRPC);
                continue;
            }
            throw new IllegalArgumentException("Unsupported socket provider: " + sType);
        }
        return new SocketProviderBuilder(sId, deps, false);
    }

    private static String getProviderIdReference(XmlElement xmlSocketProvider) {
        String sRef;
        if (xmlSocketProvider == null) {
            return null;
        }
        if (xmlSocketProvider.getElementList().isEmpty()) {
            sRef = xmlSocketProvider.getString();
            if (sRef.length() == 0) {
                return null;
            }
        } else {
            return null;
        }
        return sRef;
    }

    private static String getProviderDefinitionId(XmlElement xmlSocketProvider) {
        XmlValue valueIdAttribute = xmlSocketProvider != null ? xmlSocketProvider.getAttribute("id") : null;
        return valueIdAttribute == null ? "" : valueIdAttribute.getString("");
    }
}

