/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.net.SocketOptions;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.net.SocketException;

public class SocketOptionsProcessor
implements ElementProcessor<SocketOptions> {
    @Override
    public SocketOptions process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        SocketOptions socketOptions = new SocketOptions();
        try {
            socketOptions.setOption(8, Boolean.TRUE);
            socketOptions.setOption(1, Boolean.TRUE);
            socketOptions.setOption(128, 0);
            XmlElement xmlOption = xmlElement.getElement("reuse-address");
            if (xmlOption != null) {
                socketOptions.setOption(4, xmlOption.getBoolean(true));
            }
            if ((xmlOption = xmlElement.getElement("receive-buffer-size")) != null) {
                socketOptions.setOption(4098, (int)Base.parseMemorySize(xmlOption.getString()));
            }
            if ((xmlOption = xmlElement.getElement("send-buffer-size")) != null) {
                socketOptions.setOption(4097, (int)Base.parseMemorySize(xmlOption.getString()));
            }
            if ((xmlOption = xmlElement.getElement("timeout")) != null) {
                socketOptions.setOption(4102, (int)Base.parseTime(xmlOption.getString()));
            }
            if ((xmlOption = xmlElement.getElement("linger-timeout")) != null) {
                socketOptions.setOption(128, (int)(Base.parseTime(xmlOption.getString()) / 1000L));
            }
            if ((xmlOption = xmlElement.getElement("keep-alive-enabled")) != null) {
                socketOptions.setOption(8, xmlOption.getBoolean(true));
            }
            if ((xmlOption = xmlElement.getElement("out-of-band-inline")) != null) {
                socketOptions.setOption(4099, xmlOption.getBoolean(true));
            }
            if ((xmlOption = xmlElement.getElement("tcp-delay-enabled")) != null) {
                socketOptions.setOption(1, !xmlOption.getBoolean(true));
            }
            if ((xmlOption = xmlElement.getElement("traffic-class")) != null) {
                socketOptions.setOption(3, xmlOption.getInt());
            }
            return socketOptions;
        }
        catch (SocketException e) {
            throw new ConfigurationException("Illegal Socket Option defined in [" + String.valueOf(xmlElement) + "]", "Please ensure the Socket Options are valid", e);
        }
    }
}

