/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.InvalidConfigServiceLoadBalancerBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ProxyServiceLoadBalancerBuilder;
import com.tangosol.coherence.config.builder.ServiceLoadBalancerBuilder;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="load-balancer")
public class ServiceLoadBalancerProcessor
implements ElementProcessor<ServiceLoadBalancerBuilder> {
    public static final String PROXY_SCHEME = "proxy-scheme";
    public static final String PROXY = "proxy";
    public static final String CLIENT = "client";

    @Override
    public ServiceLoadBalancerBuilder process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        Object sLoadBalancer = xmlElement.getString().trim();
        if (sLoadBalancer == null || ((String)sLoadBalancer).length() == 0) {
            String sScheme;
            switch (sScheme = xmlElement.getParent().getQualifiedName().getLocalName()) {
                case "proxy-scheme": {
                    sLoadBalancer = PROXY;
                    break;
                }
                default: {
                    sLoadBalancer = "no default load balancer for scheme " + sScheme;
                }
            }
        }
        ParameterizedBuilder<?> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        switch (sLoadBalancer) {
            case "proxy": {
                return new ProxyServiceLoadBalancerBuilder(bldr, xmlElement);
            }
            case "client": {
                return null;
            }
        }
        return new InvalidConfigServiceLoadBalancerBuilder((String)sLoadBalancer, xmlElement);
    }
}

