/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.AbstractEmptyElementProcessor;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="serializer")
public class SerializerFactoryProcessor
extends AbstractEmptyElementProcessor<SerializerFactory> {
    public SerializerFactoryProcessor() {
        super(AbstractEmptyElementProcessor.EmptyElementBehavior.IGNORE);
    }

    @Override
    public SerializerFactory onProcess(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        SerializerFactory factory;
        ParameterizedBuilder<?> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        if (bldr == null) {
            String sName = xmlElement.getString();
            OperationalContext ctxOperational = context.getCookie(OperationalContext.class);
            if (ctxOperational == null) {
                throw new ConfigurationException("Attempted to resolve the OperationalContext in [" + String.valueOf(xmlElement) + "] but it was not defined", "The registered ElementHandler for the <serializer> element is not operating in an OperationalContext");
            }
            factory = ctxOperational.getSerializerMap().get(sName);
            if (factory == null) {
                throw new IllegalArgumentException("Serializer name \"" + sName + "\" is undefined:\n" + String.valueOf(xmlElement));
            }
        } else {
            final ParameterResolver resolver = context.getDefaultParameterResolver();
            final ParameterizedBuilder<?> bldrSerializer = bldr;
            final XmlElement f_xmlElement = xmlElement;
            factory = new SerializerFactory(){

                @Override
                public Serializer createSerializer(ClassLoader loader) {
                    try {
                        Serializer serializer = (Serializer)bldrSerializer.realize(resolver, loader, null);
                        if (serializer instanceof ClassLoaderAware) {
                            ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(loader);
                        }
                        return serializer;
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("Expected a ParameterizedBuilder<SerializerFactory>, but found [" + String.valueOf(bldrSerializer) + "] after parsing [" + String.valueOf(f_xmlElement) + "]", " Please specify the name of a registered <serializer> or a ParameterizedBuilder<SerializerFactory>", e);
                    }
                }
            };
        }
        return factory;
    }
}

