/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.internal.net.ssl.DefaultManagerDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.net.ssl.CertificateLoader;
import com.tangosol.net.ssl.PrivateKeyLoader;
import com.tangosol.run.xml.XmlElement;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class SSLManagerProcessor
implements ElementProcessor<ManagerDependencies> {
    @Override
    public ManagerDependencies process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        String sManagerKind = xmlElement.getQualifiedName().getLocalName();
        DefaultManagerDependencies dependencies = new DefaultManagerDependencies(sManagerKind);
        context.inject(dependencies, xmlElement);
        Map<String, ?> mapComponent = context.processRemainingElementsOf(xmlElement);
        Collection colComponent = mapComponent.values().stream().map(this::buildIfInstanceBuilder).collect(Collectors.toList());
        colComponent.stream().filter(o -> o instanceof PrivateKeyLoader).map(PrivateKeyLoader.class::cast).filter(PrivateKeyLoader::isEnabled).forEach(dependencies::setPrivateKeyLoader);
        CertificateLoader[] aCertLoader = (CertificateLoader[])colComponent.stream().filter(o -> o instanceof CertificateLoader).map(CertificateLoader.class::cast).filter(CertificateLoader::isEnabled).toArray(CertificateLoader[]::new);
        if (aCertLoader.length > 0) {
            dependencies.setCertificateLoaders(aCertLoader);
        }
        return dependencies;
    }

    private Object buildIfInstanceBuilder(Object o) {
        if (o instanceof ParameterizedBuilder) {
            o = ((ParameterizedBuilder)o).realize(null, null, null);
        }
        return o;
    }
}

