/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.oracle.coherence.common.base.Assertions;
import com.tangosol.coherence.config.builder.NamedResourceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;
import java.util.Map;

@XmlSimpleName(value="resources")
public class ResourcesProcessor
implements ElementProcessor<Void> {
    @Override
    public Void process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        ParameterizedBuilderRegistry registry = context.getCookie(ParameterizedBuilderRegistry.class);
        Assertions.azzert(registry != null);
        for (Map.Entry<String, ?> entry : context.processElementsOf(xmlElement).entrySet()) {
            Object oBuilder = entry.getValue();
            if (oBuilder instanceof NamedResourceBuilder) {
                NamedResourceBuilder builder = (NamedResourceBuilder)oBuilder;
                String sName = builder.getName();
                registry.registerBuilder(NamedResourceBuilder.class, sName, builder);
                continue;
            }
            throw new ConfigurationException("The <resource> [" + entry.getKey() + "] is not a ParameterizedBuilder", "Use <instance> element to specify a ParameterizedBuilder implementation");
        }
        return null;
    }
}

