/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.NamedResourceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.coherence.config.builder.StaticFactoryInstanceBuilder;
import com.tangosol.coherence.config.xml.processor.AbstractEmptyElementProcessor;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;

@XmlSimpleName(value="resource")
public class ResourceBuilderProcessor<T>
extends AbstractEmptyElementProcessor<ParameterizedBuilder<T>> {
    public ResourceBuilderProcessor() {
        super(AbstractEmptyElementProcessor.EmptyElementBehavior.PROCESS);
    }

    @Override
    public ParameterizedBuilder<T> onProcess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        ParameterizedBuilder<Object> builder = null;
        ParameterizedBuilder<?> builderInner = ElementProcessorHelper.processParameterizedBuilder(context, element);
        if (builderInner == null) {
            String sName;
            ParameterizedBuilderRegistry registry = context.getCookie(ParameterizedBuilderRegistry.class);
            if (registry == null) {
                OperationalContext ctxOperational = context.getCookie(OperationalContext.class);
                if (ctxOperational == null) {
                    throw new ConfigurationException("Attempted to resolve the OperationalContext in [" + String.valueOf(element) + "] but it was not defined", "The registered ElementHandler for the <" + element.getName() + "> element is not operating in an OperationalContext");
                }
                registry = ctxOperational.getBuilderRegistry();
            }
            if ((sName = this.getNameFromXML(element)) == null || sName.isEmpty()) {
                throw new ConfigurationException("<resource> fails to correctly define a named resource " + String.valueOf(element), "Please define a valid named <resource> by specifying a name in the 'id' attribute, using the <name> child element, or as the <resource> element's value");
            }
            NamedResourceBuilder namedBuilder = (NamedResourceBuilder)registry.getBuilder(NamedResourceBuilder.class, sName);
            if (namedBuilder == null) {
                throw new ConfigurationException("No cluster resource has been configured with the name " + sName + " configured in " + String.valueOf(element), "Please define a valid named <resource> by specifying a name in the 'id' attribute, using the <name> child element, or as the <resource> element's value");
            }
            builder = namedBuilder.getDelegate();
            if (builder instanceof InstanceBuilder) {
                builder = this.newInstanceBuilder(context, element, (InstanceBuilder)builder);
            } else if (builder instanceof StaticFactoryInstanceBuilder) {
                builder = this.newStaticFactoryInstanceBuilder(context, element, (StaticFactoryInstanceBuilder)builder);
            }
        } else {
            XmlValue xmlName = element.getAttribute("id");
            if (xmlName == null || xmlName.isEmpty()) {
                throw new ConfigurationException("<resource> does not include an id attribute: " + String.valueOf(element), "Please correctly define the <resource>");
            }
            String sName = xmlName.getString();
            if (sName == null || sName.isEmpty()) {
                throw new ConfigurationException("<resource> does not include an id attribute: " + String.valueOf(element), "Please correctly define the <resource>");
            }
            builder = new NamedResourceBuilder(builderInner, sName);
        }
        if (builder == null) {
            throw new ConfigurationException("<resource> fails to correctly define a resource implementation: " + String.valueOf(element), "Please define a valid <resource>");
        }
        return builder;
    }

    private String getNameFromXML(XmlElement xmlElement) {
        String sName;
        XmlValue xmlName = xmlElement.getElement("name");
        if (xmlName == null) {
            xmlName = xmlElement.getAttribute("id");
        }
        String string = sName = xmlName == null ? null : xmlName.getString();
        if (sName == null && xmlElement.getElementList().isEmpty()) {
            sName = xmlElement.getString();
        }
        return sName == null ? null : sName.trim();
    }

    private InstanceBuilder<T> newInstanceBuilder(ProcessingContext context, XmlElement xmlElement, InstanceBuilder<T> builder) {
        ResolvableParameterList parameterList = this.extractParameters(context, xmlElement, builder.getConstructorParameterList());
        if (parameterList == null) {
            return builder;
        }
        InstanceBuilder bldrOverridden = new InstanceBuilder();
        bldrOverridden.setClassName(builder.getClassName());
        bldrOverridden.setConstructorParameterList(parameterList);
        return bldrOverridden;
    }

    private StaticFactoryInstanceBuilder<T> newStaticFactoryInstanceBuilder(ProcessingContext context, XmlElement xmlElement, StaticFactoryInstanceBuilder<T> builder) {
        ResolvableParameterList parameterList = this.extractParameters(context, xmlElement, builder.getFactoryMethodParameters());
        if (parameterList == null) {
            return builder;
        }
        StaticFactoryInstanceBuilder bldrOverridden = new StaticFactoryInstanceBuilder();
        bldrOverridden.setFactoryClassName(builder.getFactoryClassName());
        bldrOverridden.setFactoryMethodName(builder.getFactoryMethodName());
        bldrOverridden.setFactoryMethodParameters(parameterList);
        return bldrOverridden;
    }

    private ResolvableParameterList extractParameters(ProcessingContext context, XmlElement xmlElement, ParameterList list) {
        if (xmlElement.getElement("init-params") == null) {
            return null;
        }
        ResolvableParameterList parameterList = new ResolvableParameterList(list);
        XmlElement element = xmlElement.getSafeElement("init-params");
        ResolvableParameterList listOverrideParams = (ResolvableParameterList)context.processElement(element);
        for (Parameter parameter : listOverrideParams) {
            parameterList.add(parameter);
        }
        return parameterList;
    }
}

