/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.PersistenceEnvironmentParamBuilder;
import com.tangosol.coherence.config.xml.processor.AbstractEmptyElementProcessor;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.grid.DefaultPersistenceDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.net.OperationalContext;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="persistence")
public class PersistenceProcessor
extends AbstractEmptyElementProcessor<PersistenceDependencies> {
    public PersistenceProcessor() {
        super(AbstractEmptyElementProcessor.EmptyElementBehavior.PROCESS);
    }

    @Override
    public PersistenceDependencies onProcess(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        String sFailureMode;
        DefaultPersistenceDependencies depsPersistence = new DefaultPersistenceDependencies();
        OperationalContext ctxOp = context.getCookie(OperationalContext.class);
        XmlElement xmlEnvironment = xmlElement.getSafeElement("environment");
        String sMode = Config.getProperty("coherence.distributed.persistence.mode", () -> Config.getProperty("coherence.distributed.persistence-mode", "on-demand"));
        Object sEnvName = xmlEnvironment.isEmpty() ? "default-" + sMode : xmlEnvironment.getString();
        PersistenceEnvironmentParamBuilder bldr = (PersistenceEnvironmentParamBuilder)ctxOp.getBuilderRegistry().getBuilder(PersistenceEnvironment.class, (String)sEnvName);
        if (bldr == null) {
            throw new IllegalArgumentException("Persistence environment (\"" + (String)sEnvName + "\") must be defined in the operational config");
        }
        depsPersistence.setPersistenceMode(bldr.getPersistenceMode());
        depsPersistence.setPersistenceEnvironmentBuilder(bldr);
        String sArchiver = xmlElement.getSafeElement("archiver").getString();
        if (!sArchiver.isEmpty()) {
            SnapshotArchiverFactory factory = ctxOp.getSnapshotArchiverMap().get(sArchiver);
            if (factory == null) {
                throw new IllegalArgumentException("Snapshot archiver (\"" + sArchiver + "\") must be defined in the operational configuration");
            }
            depsPersistence.setArchiverFactory(factory);
        }
        switch (sFailureMode = xmlElement.getSafeElement("active-failure-mode").getString("stop-service")) {
            case "stop-service": {
                depsPersistence.setFailureMode(0);
                break;
            }
            case "stop-persistence": {
                depsPersistence.setFailureMode(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown persistence active-failure-mode: " + sFailureMode);
            }
        }
        return depsPersistence;
    }
}

