/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.PartitionedCacheQuorumPolicyBuilder;
import com.tangosol.coherence.config.xml.processor.AddressProviderBuilderProcessor;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.lang.reflect.Type;

@XmlSimpleName(value="partitioned-quorum-policy-scheme")
public class PartitionedQuorumPolicyProcessor
implements ElementProcessor<ActionPolicyBuilder> {
    @Override
    public ActionPolicyBuilder process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        ParameterizedBuilder<ActionPolicy> builderCustom = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        if (builderCustom == null) {
            XmlElement xmlRecoveryHosts = xmlElement.getSafeElement("recovery-hosts");
            AddressProviderBuilder bldrRecoveryHosts = xmlRecoveryHosts.isEmpty() ? null : new AddressProviderBuilderProcessor().process(context, xmlRecoveryHosts);
            PartitionedCacheQuorumPolicyBuilder builder = new PartitionedCacheQuorumPolicyBuilder(bldrRecoveryHosts, xmlElement);
            for (ConfigurableQuorumPolicy.PartitionedCacheQuorumPolicy.ActionRule action : ConfigurableQuorumPolicy.PartitionedCacheQuorumPolicy.ActionRule.values()) {
                int nThreshold = 0;
                float flThresholdPct = 0.0f;
                if (action.getMask() == 16) {
                    String sElementName = action.getElementName();
                    String sThreshold = context.getOptionalProperty(sElementName, (Type)((Object)String.class), "0", xmlElement);
                    int ofPct = sThreshold.indexOf("%");
                    if (ofPct >= 0) {
                        try {
                            flThresholdPct = Base.parsePercentage(sThreshold);
                        }
                        catch (IllegalArgumentException e) {
                            throw new ConfigurationException("The partitioned-quorum-policy-scheme/" + sElementName + " value is not valid: " + sThreshold, "Please ensure that the value is a non-nagative integer with or without a %  <" + sElementName + ">");
                        }
                    } else {
                        nThreshold = Integer.parseInt(sThreshold);
                    }
                } else {
                    nThreshold = context.getOptionalProperty(action.getElementName(), (Type)((Object)Integer.class), 0, xmlElement);
                }
                builder.addQuorumRule(action.getElementName(), action.getMask(), nThreshold, flThresholdPct);
            }
            return builder;
        }
        return new ActionPolicyBuilder.ActionPolicyParameterizedBuilder(builderCustom);
    }
}

