/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.PagedTopicScheme;
import com.tangosol.coherence.config.scheme.PagedTopicStorageScheme;
import com.tangosol.coherence.config.xml.processor.ServiceBuilderProcessor;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.grid.DefaultPagedTopicServiceDependencies;
import com.tangosol.internal.net.service.grid.PagedTopicServiceDependencies;
import com.tangosol.internal.net.topic.impl.paged.SubscriberCleanupListener;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.SafeConfigurablePofContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ExternalizableHelper;
import java.util.Collections;

@XmlSimpleName(value="paged-topic-scheme")
public class PagedTopicSchemeProcessor
extends ServiceBuilderProcessor<PagedTopicScheme> {
    public PagedTopicSchemeProcessor() {
        super(PagedTopicScheme.class);
    }

    public PagedTopicSchemeProcessor(Class<PagedTopicScheme> clzToRealize) {
        super(clzToRealize);
    }

    @Override
    public PagedTopicScheme process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        PagedTopicScheme scheme = (PagedTopicScheme)super.process(context, element);
        PagedTopicServiceDependencies depService = (PagedTopicServiceDependencies)scheme.getServiceDependencies();
        DefaultPagedTopicServiceDependencies deps = new DefaultPagedTopicServiceDependencies(depService);
        final SerializerFactory factory = deps.getSerializerFactory();
        SerializerFactory factoryPof = new SerializerFactory(){

            @Override
            public Serializer createSerializer(ClassLoader loader) {
                Serializer serializer = factory == null ? ExternalizableHelper.ensureSerializer(loader) : factory.createSerializer(loader);
                return serializer instanceof PofContext ? serializer : new SafeConfigurablePofContext(serializer, loader);
            }

            @Override
            public String getName() {
                return "topics-pof";
            }
        };
        deps.setMemberListenerBuilders(Collections.singletonList(new InstanceBuilder(SubscriberCleanupListener.class, new Object[0])));
        deps.setPartitionListenerBuilders(Collections.singletonList(new InstanceBuilder(SubscriberCleanupListener.class, new Object[0])));
        deps.setSerializerFactory(factoryPof);
        scheme.setServiceDependencies(deps);
        CachingScheme schemeStorage = scheme.getStorageScheme(context.getDefaultParameterResolver());
        BackingMapScheme backingMapScheme = new BackingMapScheme();
        backingMapScheme.setStorageAccessAuthorizer(scheme.getStorageAccessAuthorizer());
        backingMapScheme.setTransient(scheme.getTransientExpression());
        backingMapScheme.setPartitioned(new LiteralExpression<String>("true"));
        backingMapScheme.setInnerScheme(new PagedTopicStorageScheme(schemeStorage, scheme));
        scheme.setBackingMapScheme(backingMapScheme);
        return scheme;
    }
}

