/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.coherence.http.GenericHttpServer;
import com.tangosol.coherence.http.HttpApplication;
import com.tangosol.coherence.http.HttpServer;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.peer.acceptor.DefaultHttpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.run.xml.XmlElement;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.glassfish.jersey.server.ResourceConfig;

@XmlSimpleName(value="http-acceptor")
public class HttpAcceptorDependenciesProcessor
implements ElementProcessor<HttpAcceptorDependencies> {
    @Override
    public HttpAcceptorDependencies process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        GenericHttpServer<ResourceConfig> httpServer;
        DefaultHttpAcceptorDependencies dependencies = new DefaultHttpAcceptorDependencies();
        ParameterizedBuilder<?> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        if (bldr == null) {
            httpServer = HttpServer.create();
        } else {
            try {
                ParameterizedBuilder<?> bldrHttpServer = bldr;
                httpServer = (GenericHttpServer)bldrHttpServer.realize(context.getDefaultParameterResolver(), context.getContextClassLoader(), null);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Invalid <" + xmlElement.getName() + "> declaration.  The specified element doesn't produce a HttpServer as expected in [" + String.valueOf(xmlElement) + "]", "Please specify a valid <" + xmlElement.getName() + ">");
            }
        }
        dependencies.setHttpServer(httpServer);
        HashMap<String, Object> mapConfig = new HashMap<String, Object>();
        Iterator iter = xmlElement.getElements("resource-config");
        while (iter.hasNext()) {
            XmlElement xmlResourceConfig = (XmlElement)iter.next();
            String sContextPath = context.getOptionalProperty("context-path", (Type)((Object)String.class), null, xmlResourceConfig);
            ParameterizedBuilder<?> bldrResourceConfig = ElementProcessorHelper.processParameterizedBuilder(context, xmlResourceConfig);
            if (bldrResourceConfig == null) {
                bldrResourceConfig = new InstanceBuilder("com.tangosol.coherence.rest.server.DefaultResourceConfig", new Object[0]);
            }
            Class<ResourceConfig> clzResource = httpServer.getResourceType();
            try {
                Object oResourceConfig = bldrResourceConfig.realize(context.getDefaultParameterResolver(), context.getContextClassLoader(), null);
                try {
                    if (oResourceConfig instanceof Application) {
                        oResourceConfig = ResourceConfig.forApplication((Application)((Application)oResourceConfig));
                    }
                }
                catch (IllegalAccessError | NoClassDefFoundError linkageError) {
                    // empty catch block
                }
                if (!clzResource.isAssignableFrom(oResourceConfig.getClass())) {
                    throw new IllegalArgumentException("<resource-config> is not an instance of " + clzResource.getCanonicalName());
                }
                if (sContextPath == null) {
                    ApplicationPath path = oResourceConfig.getClass().getAnnotation(ApplicationPath.class);
                    sContextPath = path == null ? "/" : path.value();
                }
                mapConfig.put(sContextPath, oResourceConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to realize the <resource-config> specified by [" + String.valueOf(xmlResourceConfig) + "] as the underlying class could not be found", "Please ensure that the class is available on the class path", e);
            }
        }
        if (mapConfig.isEmpty()) {
            ServiceLoader<HttpApplication> loaderApps = ServiceLoader.load(HttpApplication.class);
            for (HttpApplication app : loaderApps) {
                mapConfig.put(app.getPath(), app.configure());
            }
        }
        dependencies.setResourceConfig(mapConfig);
        context.inject(dependencies, xmlElement);
        return dependencies;
    }
}

