/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.health.HealthCheckDependencies;
import com.tangosol.run.xml.XmlElement;

@XmlSimpleName(value="health")
public class HealthProcessor
implements ElementProcessor<HealthCheckDependencies> {
    @Override
    public HealthCheckDependencies process(ProcessingContext ctx, XmlElement element) throws ConfigurationException {
        XMLHealthCheckDependencies dependencies = new XMLHealthCheckDependencies();
        ctx.inject(dependencies, element);
        return dependencies;
    }

    public static class XMLHealthCheckDependencies
    implements HealthCheckDependencies {
        private boolean m_fMemberHealthCheck = true;
        private boolean m_fAllowEndangered;

        @Injectable(value="member-health-check")
        public void setMemberHealthCheck(boolean fEnabled) {
            this.m_fMemberHealthCheck = fEnabled;
        }

        @Override
        public boolean isMemberHealthCheck() {
            return this.m_fMemberHealthCheck;
        }

        @Injectable(value="allow-endangered")
        public void setAllowEndangered(boolean fAllowEndangered) {
            this.m_fAllowEndangered = fAllowEndangered;
        }

        @Override
        public boolean allowEndangered() {
            return this.m_fAllowEndangered;
        }
    }
}

