/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.scheme.AbstractServiceScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.ServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultPartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PartitionedServiceDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.util.Map;

@XmlSimpleName(value="caching-schemes")
public class CachingSchemesProcessor
implements ElementProcessor<ServiceSchemeRegistry> {
    @Override
    public ServiceSchemeRegistry process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        Map<String, ?> mapProcessedChildren = context.processElementsOf(xmlElement);
        CacheConfig cacheConfig = context.getCookie(CacheConfig.class);
        Base.azzert(cacheConfig != null);
        ServiceSchemeRegistry registry = cacheConfig.getServiceSchemeRegistry();
        Base.azzert(registry != null);
        for (Object oChild : mapProcessedChildren.values()) {
            if (!(oChild instanceof ServiceScheme)) continue;
            ServiceScheme scheme = (ServiceScheme)oChild;
            ServiceDependencies depsService = (ServiceDependencies)((AbstractServiceScheme)scheme).getServiceDependencies();
            String sNameService = scheme.getScopedServiceNameForProperty();
            if (depsService instanceof PartitionedServiceDependencies) {
                int cPartitions = ((PartitionedServiceDependencies)depsService).getPreferredPartitionCount();
                int cPartitionsOverride = Config.getInteger(String.format("coherence.service.%s.partitions", sNameService), DefaultPartitionedServiceDependencies.DEFAULT_SERVICE_PARTITIONS == -1 ? cPartitions : DefaultPartitionedServiceDependencies.DEFAULT_SERVICE_PARTITIONS);
                ((DefaultPartitionedServiceDependencies)depsService).setPreferredPartitionCount(cPartitionsOverride);
                if (cPartitionsOverride != cPartitions) {
                    Logger.config("Configured service " + scheme.getScopedServiceName() + " using partition count of " + cPartitions);
                }
            }
            registry.register((ServiceScheme)oChild);
        }
        context.processForeignElementsOf(xmlElement);
        return registry;
    }
}

