/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.config.xml.OverrideProcessor;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.util.ArrayList;

public class CacheConfigOverrideProcessor
implements OverrideProcessor {
    @Override
    public void process(XmlElement xmlBase, XmlElement xmlOverride) {
        XmlHelper.mergeSchema(xmlBase, xmlOverride);
        for (Object overrideElements : xmlOverride.getElementList()) {
            XmlElement xmlElement = (XmlElement)overrideElements;
            if ("caching-scheme-mapping".equals(xmlElement.getName())) {
                this.processSchemeMappings(xmlBase, xmlElement, "cache-name");
                continue;
            }
            if ("topic-scheme-mapping".equals(xmlElement.getName())) {
                this.processSchemeMappings(xmlBase, xmlElement, "topic-name");
                continue;
            }
            if ("caching-schemes".equals(xmlElement.getName())) {
                this.processCachingSchemes(xmlBase, xmlElement);
                continue;
            }
            if ("interceptors".equals(xmlElement.getName())) {
                this.processInterceptors(xmlBase, xmlElement);
                continue;
            }
            ArrayList<XmlElement> listElements = new ArrayList<XmlElement>();
            listElements.add(xmlElement);
            XmlHelper.addElements(xmlBase, listElements.iterator());
        }
    }

    private void processSchemeMappings(XmlElement xmlBase, XmlElement xmlOverrideSchemeMappings, String sMappingSubElementName) {
        ArrayList<XmlElement> listElements = new ArrayList<XmlElement>();
        XmlElement xmlCurrentElement = xmlBase.getElement(xmlOverrideSchemeMappings.getName());
        if (xmlCurrentElement == null) {
            listElements.add(xmlOverrideSchemeMappings);
            XmlHelper.addElements(xmlBase, listElements.iterator());
            listElements.clear();
            return;
        }
        for (Object subElements : xmlOverrideSchemeMappings.getElementList()) {
            XmlElement xmlElementOverride = (XmlElement)subElements;
            String absXmlPath = xmlElementOverride.getAbsolutePath();
            String xmlPath = absXmlPath.substring("/cache-config/".length(), absXmlPath.lastIndexOf("/"));
            XmlElement xmlElementParent = xmlBase.getElement(xmlPath);
            XmlElement xmlSchemeOverride = xmlElementOverride.getElement("scheme-name");
            String sSubElementName = xmlElementOverride.getName();
            if (xmlElementParent != null && xmlSchemeOverride != null) {
                String sOverrideSchemeName = xmlSchemeOverride.getValue().toString();
                for (Object baseElements : xmlElementParent.getElementList()) {
                    XmlElement xmlElementBase = (XmlElement)baseElements;
                    XmlElement xmlElementScheme = xmlElementBase.getElement("scheme-name");
                    String xmlElementName = xmlElementBase.getName();
                    if (xmlElementScheme == null) continue;
                    String sSchemeName = xmlElementScheme.getValue().toString();
                    String sCacheNameBase = xmlElementBase.getElement(sMappingSubElementName).toString();
                    String sCacheNameOverride = xmlElementOverride.getElement(sMappingSubElementName).toString();
                    if (sCacheNameOverride.equals(sCacheNameBase)) {
                        XmlHelper.overrideElement(xmlElementBase, xmlElementOverride);
                        continue;
                    }
                    if (!listElements.contains(xmlElementOverride)) {
                        listElements.add(xmlElementOverride);
                        continue;
                    }
                    if (sSchemeName.equals(sOverrideSchemeName)) {
                        XmlElement removeElement = null;
                        for (XmlElement xmlEl : listElements) {
                            XmlElement xmlElSchemeName = xmlEl.getElement("scheme-name");
                            if (xmlElSchemeName == null || !sOverrideSchemeName.equals(xmlElSchemeName.getValue().toString())) continue;
                            removeElement = xmlEl;
                            break;
                        }
                        if (removeElement != null) {
                            listElements.remove(removeElement);
                        }
                        if (!xmlElementName.equals(sSubElementName)) {
                            xmlElementBase.setName(sSubElementName);
                        }
                        XmlHelper.overrideElement(xmlElementBase, xmlElementOverride);
                        continue;
                    }
                    if (listElements.contains(xmlElementOverride)) continue;
                    listElements.add(xmlElementOverride);
                }
                continue;
            }
            if (xmlElementParent != null && !xmlElementParent.getElementList().isEmpty()) {
                for (Object oBaseElement : xmlElementParent.getElementList()) {
                    XmlElement xmlElementBase = (XmlElement)oBaseElement;
                    XmlHelper.overrideElement(xmlElementBase, xmlElementOverride);
                }
                continue;
            }
            if (listElements.contains(xmlElementOverride)) continue;
            listElements.add(xmlElementOverride);
        }
        if (!listElements.isEmpty()) {
            for (Object subElements : xmlCurrentElement.getElementList()) {
                XmlElement subElement = (XmlElement)subElements;
                listElements.add(subElement);
            }
            for (XmlElement subElement : listElements) {
                XmlHelper.removeElement(xmlCurrentElement, subElement.getName());
            }
            XmlHelper.addElements(xmlCurrentElement, listElements.iterator());
            listElements.clear();
        }
    }

    private void processCachingSchemes(XmlElement xmlBase, XmlElement xmlOverrideCachingSchemes) {
        ArrayList<XmlElement> listElements = new ArrayList<XmlElement>();
        for (Object subElements : xmlOverrideCachingSchemes.getElementList()) {
            XmlElement xmlOverride = (XmlElement)subElements;
            String absXmlPath = xmlOverride.getAbsolutePath();
            String xmlPath = absXmlPath.substring("/cache-config/".length(), absXmlPath.lastIndexOf("/"));
            XmlElement xmlElementParent = xmlBase.getElement(xmlPath);
            XmlElement xmlSchemeOverride = xmlOverride.getElement("scheme-name");
            String sSubElementName = xmlOverride.getName();
            if (xmlSchemeOverride != null) {
                String sOverrideSchemeName = xmlSchemeOverride.getValue().toString();
                for (Object baseElements : xmlElementParent.getElementList()) {
                    XmlElement xmlElementBase = (XmlElement)baseElements;
                    XmlElement xmlElementScheme = xmlElementBase.getElement("scheme-name");
                    String xmlElementName = xmlElementBase.getName();
                    if (xmlElementScheme == null) continue;
                    String sSchemeName = xmlElementScheme.getValue().toString();
                    if (sSchemeName.equals(sOverrideSchemeName)) {
                        XmlElement xmlElementRemove = null;
                        for (XmlElement xmlEl : listElements) {
                            XmlElement xmlElSchemeName = xmlEl.getElement("scheme-name");
                            if (xmlElSchemeName == null || !sOverrideSchemeName.equals(xmlElSchemeName.getValue().toString())) continue;
                            xmlElementRemove = xmlEl;
                            break;
                        }
                        if (xmlElementRemove != null) {
                            listElements.remove(xmlElementRemove);
                        }
                        if (!xmlElementName.equals(sSubElementName)) {
                            xmlElementBase.setName(sSubElementName);
                        }
                        XmlHelper.overrideElement(xmlElementBase, xmlOverride);
                        continue;
                    }
                    if (listElements.contains(xmlOverride)) continue;
                    listElements.add(xmlOverride);
                }
                continue;
            }
            if (!xmlElementParent.getElementList().isEmpty()) {
                for (Object oBaseElement : xmlElementParent.getElementList()) {
                    XmlElement xmlElementFromBase = (XmlElement)oBaseElement;
                    XmlHelper.overrideElement(xmlElementFromBase, xmlOverride);
                }
                continue;
            }
            if (listElements.contains(xmlOverride)) continue;
            listElements.add(xmlOverride);
        }
        if (!listElements.isEmpty()) {
            XmlHelper.addElements(xmlBase.getElement(xmlOverrideCachingSchemes.getName()), listElements.iterator());
            listElements.clear();
        }
    }

    private void processInterceptors(XmlElement xmlBase, XmlElement xmlOverrideInterceptors) {
        ArrayList<XmlElement> listElements = new ArrayList<XmlElement>();
        String xmlPathOverride = xmlOverrideInterceptors.getAbsolutePath();
        String xmlPathBase = xmlPathOverride.substring("/cache-config/".length());
        XmlElement xmlInterceptorsBase = xmlBase.getElement(xmlPathBase);
        if (xmlInterceptorsBase == null) {
            listElements.add(xmlOverrideInterceptors);
            XmlHelper.addElements(xmlBase, listElements.iterator());
        } else {
            for (Object xmlInterceptorsOverride : xmlOverrideInterceptors.getElementList()) {
                XmlElement xmlInterceptorOverride = (XmlElement)xmlInterceptorsOverride;
                if (xmlInterceptorOverride.getElement("name") != null) {
                    String sInterceptorNameOverride = xmlInterceptorOverride.getElement("name").getValue().toString();
                    for (Object subElements : xmlInterceptorsBase.getElementList()) {
                        XmlElement xmlInterceptorBase = (XmlElement)subElements;
                        if (xmlInterceptorBase.getElement("name") == null) continue;
                        if (sInterceptorNameOverride.equals(xmlInterceptorBase.getElement("name").getValue().toString())) {
                            XmlHelper.overrideElement(xmlInterceptorBase, xmlInterceptorOverride);
                            continue;
                        }
                        if (listElements.contains(xmlInterceptorOverride)) continue;
                        listElements.add(xmlInterceptorOverride);
                    }
                    continue;
                }
                if (listElements.contains(xmlInterceptorOverride)) continue;
                listElements.add(xmlInterceptorOverride);
            }
            if (!listElements.isEmpty()) {
                XmlHelper.addElements(xmlInterceptorsBase, listElements.iterator());
                listElements.clear();
            }
        }
    }
}

