/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.builder.InetAddressRangeFilterBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Filter;
import java.util.Iterator;

@XmlSimpleName(value="authorized-hosts")
public class AuthorizedHostsProcessor
implements ElementProcessor<ParameterizedBuilder<Filter>> {
    @Override
    public ParameterizedBuilder<Filter> process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        XmlElement xmlHost;
        XmlElement xmlHostsFilter = xmlElement.getElement("host-filter");
        if (xmlHostsFilter != null && !XmlHelper.isEmpty(xmlHostsFilter)) {
            ParameterizedBuilder<Filter> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlHostsFilter);
            return bldr;
        }
        InetAddressRangeFilterBuilder builder = new InetAddressRangeFilterBuilder();
        Iterator iter = xmlElement.getElements("host-address");
        while (iter.hasNext()) {
            xmlHost = (XmlElement)iter.next();
            builder.addAuthorizedHostsToFilter(xmlHost.getString(), null);
        }
        iter = xmlElement.getElements("host-range");
        while (iter.hasNext()) {
            xmlHost = (XmlElement)iter.next();
            builder.addAuthorizedHostsToFilter(xmlHost.getSafeElement("from-address").getString(), xmlHost.getSafeElement("to-address").getString());
        }
        return builder;
    }
}

