/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.CustomAddressProviderBuilder;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ListBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.LocalAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.util.List;

public class AddressProviderBuilderProcessor
implements ElementProcessor<ParameterizedBuilder<AddressProvider>> {
    @Override
    public AddressProviderBuilder process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        ParameterizedBuilder<AddressProvider> bldr;
        AddressProviderBuilder bldrAddressProvider = null;
        if (XmlHelper.hasElement(xmlElement, "address-provider")) {
            xmlElement = xmlElement.getElement("address-provider");
        }
        if ((bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement)) == null) {
            List listElements = xmlElement.getElementList();
            if (listElements.size() == 0) {
                String sName = xmlElement.getString().trim();
                OperationalContext ctxOperational = context.getCookie(OperationalContext.class);
                if (ctxOperational == null) {
                    ConfigurationException e = new ConfigurationException("Attempted to resolve the OperationalContext in [" + String.valueOf(xmlElement) + "] but it was not defined", "The registered ElementHandler for the <" + xmlElement.getName() + "> element is not operating in an OperationalContext");
                    bldrAddressProvider = new FactoryBasedAddressProviderBuilder(null).setDeferredException(e);
                } else {
                    AddressProviderFactory factory = ctxOperational.getAddressProviderMap().get(sName);
                    if (factory == null) {
                        Logger.warn("The address provider named '" + sName + "', specified in [" + String.valueOf(xmlElement) + "], cannot be found. Please ensure that the address provider is correctly defined in the operational configuration override file");
                    } else {
                        bldrAddressProvider = new FactoryBasedAddressProviderBuilder(factory);
                    }
                }
            } else if (listElements.size() == 1 && XmlHelper.hasElement(xmlElement, "local-address")) {
                bldrAddressProvider = AddressProviderBuilderProcessor.newLocalAddressProviderBuilder((XmlElement)listElements.get(0));
            } else {
                ListBasedAddressProviderBuilder bldrAddressListProvider = new ListBasedAddressProviderBuilder();
                block9: for (XmlElement xmlAddr : xmlElement.getElementList()) {
                    int nPort;
                    String sAddr;
                    switch (xmlAddr.getName()) {
                        case "socket-address": {
                            if (xmlElement.getName().equalsIgnoreCase("well-known-addresses")) {
                                Logger.warn("The use of <socket-address> for the <well-known-addresses> element is deprecated and the <port> value is ignored. Use <address> instead.");
                            }
                            sAddr = xmlAddr.getSafeElement("address").getString().trim();
                            nPort = xmlAddr.getSafeElement("port").getInt();
                            break;
                        }
                        case "host-address": 
                        case "address": {
                            sAddr = xmlAddr.getString().trim();
                            nPort = 0;
                            if (!xmlElement.getName().equals("name-service-addresses")) break;
                            nPort = CacheFactory.getCluster().getDependencies().getGroupPort();
                            break;
                        }
                        default: {
                            continue block9;
                        }
                    }
                    if (sAddr.isEmpty()) continue;
                    bldrAddressListProvider.add(sAddr, nPort);
                }
                if (!bldrAddressListProvider.isEmpty()) {
                    bldrAddressProvider = bldrAddressListProvider;
                }
            }
        } else {
            bldrAddressProvider = new CustomAddressProviderBuilder(bldr, context.getDefaultParameterResolver(), xmlElement);
        }
        return bldrAddressProvider;
    }

    public static AddressProviderBuilder newLocalAddressProviderBuilder(XmlElement xmlLocalAddress) {
        XmlElement xmlAddress = xmlLocalAddress.getSafeElement("address");
        XmlElement xmlPort = xmlLocalAddress.getSafeElement("port");
        XmlElement xmlPortAdjust = xmlLocalAddress.getSafeElement("port-auto-adjust");
        String sAddress = xmlAddress.getString().trim();
        String sPort = xmlPort.getString("").trim();
        int nPort = sPort.isEmpty() ? -1 : xmlPort.getInt();
        String sPortAdjust = xmlPortAdjust.getString("true").trim();
        int nPortAdjust = nPort <= 0 ? nPort : (sPortAdjust.compareToIgnoreCase("true") == 0 ? 65535 : (sPortAdjust.compareToIgnoreCase("false") == 0 ? nPort : Integer.parseInt(sPortAdjust)));
        return new LocalAddressProviderBuilder(sAddress, nPort, nPortAdjust, xmlLocalAddress);
    }
}

