/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.run.xml.XmlElement;
import java.util.Iterator;

@XmlSimpleName(value="acceptor-config")
public class AcceptorDependenciesProcessor
implements ElementProcessor<AcceptorDependencies> {
    @Override
    public AcceptorDependencies process(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        XmlElement xmlAcceptor = null;
        Iterator iter = xmlElement.getElementList().iterator();
        while (iter.hasNext() && xmlAcceptor == null) {
            XmlElement xmlCurrent = (XmlElement)iter.next();
            if (!xmlCurrent.getName().endsWith("-acceptor")) continue;
            xmlAcceptor = xmlCurrent;
        }
        if (xmlAcceptor == null) {
            DefaultTcpAcceptorDependencies dependencies = new DefaultTcpAcceptorDependencies();
            context.inject(dependencies, xmlElement);
            return dependencies;
        }
        Object oAcceptorDependencies = context.processElement(xmlAcceptor);
        if (oAcceptorDependencies instanceof AcceptorDependencies) {
            AcceptorDependencies dependencies = (AcceptorDependencies)oAcceptorDependencies;
            context.inject(dependencies, xmlElement);
            return dependencies;
        }
        throw new ConfigurationException("The specified acceptor configuration [" + String.valueOf(xmlAcceptor) + "] does not produce an AcceptorDependencies", "Please ensure that the acceptor produces an AcceptorDependencies implementation.");
    }
}

