/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;

public class TCPAcceptorPreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    @Override
    public boolean preprocess(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        if (xmlElement.getName().equals("tcp-acceptor")) {
            boolean fProvider;
            XmlElement xmlLocal = xmlElement.getSafeElement("local-address");
            XmlElement xmlProvider = xmlElement.getSafeElement("address-provider");
            boolean fLocal = !XmlHelper.isEmpty(xmlLocal);
            boolean bl = fProvider = !XmlHelper.isEmpty(xmlProvider);
            if (fLocal && fProvider) {
                throw new ConfigurationException("<address-provider> and <local-address> elements are mutually exclusive", "Please define one or the other.");
            }
            if (fLocal) {
                xmlProvider = new SimpleElement("address-provider");
                XmlElement xmlLocalAddress = xmlProvider.addElement("local-address");
                for (XmlElement xmlChild : xmlLocal.getElementList()) {
                    xmlLocalAddress.ensureElement(xmlChild.getName()).setString(xmlChild.getString());
                }
                xmlElement.getElementList().remove(xmlLocal);
                xmlElement.getElementList().add(xmlProvider);
                return true;
            }
            return false;
        }
        return false;
    }
}

