/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class OperationalDefaultsPreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    private ArrayList<DefaultsDefinition> m_listDefaultsDefinitions = new ArrayList();

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        for (DefaultsDefinition defaultDefn : this.m_listDefaultsDefinitions) {
            if (!defaultDefn.matches(element)) continue;
            XmlElement defaults = defaultDefn.getDefaultsElement();
            List listDefaultChildren = defaults.getElementList();
            for (XmlElement defaultChild : listDefaultChildren) {
                if (element.getElement(defaultChild.getName()) != null) continue;
                XmlElement child = (XmlElement)defaultChild.clone();
                element.getElementList().add(child);
            }
        }
        return false;
    }

    public void addDefaultsDefinition(String sPath, XmlElement defaultsElement) {
        this.m_listDefaultsDefinitions.add(new DefaultsDefinition(sPath, defaultsElement));
    }

    private static class DefaultsDefinition {
        private ArrayList<String> m_listRequiredElementParentNames = new ArrayList(10);
        private XmlElement m_xmlDefaultsElement;

        public DefaultsDefinition(String sPath, XmlElement defaultsElement) {
            sPath = sPath.trim();
            if (sPath.startsWith("/")) {
                this.m_listRequiredElementParentNames.add("/");
            }
            StringTokenizer tokenizer = new StringTokenizer(sPath, "/");
            while (tokenizer.hasMoreTokens()) {
                this.m_listRequiredElementParentNames.add(tokenizer.nextToken());
            }
            this.m_xmlDefaultsElement = defaultsElement;
        }

        public XmlElement getDefaultsElement() {
            return this.m_xmlDefaultsElement;
        }

        public boolean matches(XmlElement element) {
            boolean fPathMatches = true;
            for (int i = this.m_listRequiredElementParentNames.size() - 1; i >= 0 && fPathMatches; --i) {
                String sParentName = this.m_listRequiredElementParentNames.get(i);
                if (element != null && sParentName.equals("/")) {
                    fPathMatches = element.getParent() == null;
                    continue;
                }
                if (element != null && element.getName().equals(sParentName)) {
                    element = element.getParent();
                    continue;
                }
                fPathMatches = false;
            }
            return fPathMatches;
        }
    }
}

