/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CacheDefaultsPreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    private String m_sDefaultsParentPath;
    private ArrayList<DefaultDefinition> m_listDefaultDefinitions;

    public CacheDefaultsPreprocessor(String sDefaultsParentPath) {
        Base.azzert(sDefaultsParentPath != null && sDefaultsParentPath.startsWith("/"));
        this.m_sDefaultsParentPath = sDefaultsParentPath.trim();
        if (this.m_sDefaultsParentPath.endsWith("/") && this.m_sDefaultsParentPath.length() > 1) {
            this.m_sDefaultsParentPath = this.m_sDefaultsParentPath.substring(0, this.m_sDefaultsParentPath.length() - 1);
        }
        this.m_listDefaultDefinitions = new ArrayList();
    }

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        String sElementPath = this.getPathToRoot(element);
        if (!sElementPath.startsWith(this.m_sDefaultsParentPath)) {
            List listElementChildren = element.getElementList();
            for (DefaultDefinition defaultDefn : this.m_listDefaultDefinitions) {
                XmlElement defaultElement;
                if (!defaultDefn.matches(element) || element.getElement(defaultDefn.getRequiredElementName()) != null || (defaultElement = element.findElement(this.m_sDefaultsParentPath + "/" + defaultDefn.getRequiredElementName())) == null || listElementChildren.isEmpty() && !element.getString().isEmpty()) continue;
                XmlElement requiredElement = (XmlElement)defaultElement.clone();
                listElementChildren.add(requiredElement);
            }
        }
        return false;
    }

    public void addDefaultDefinition(String sRequiredElementParentPath, String sRequiredElementName) {
        this.m_listDefaultDefinitions.add(new DefaultDefinition(sRequiredElementParentPath, sRequiredElementName));
    }

    private String getPathToRoot(XmlElement element) {
        if (element == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (element.getParent() != null) {
            builder.insert(0, "/" + element.getName());
            element = element.getParent();
        }
        return builder.length() == 0 ? "/" : builder.toString();
    }

    private static class DefaultDefinition {
        private ArrayList<String> m_listRequiredElementParentNames = new ArrayList(10);
        private String m_sRequiredElementName;

        public DefaultDefinition(String sRequiredElementParentPath, String sRequiredElementName) {
            sRequiredElementParentPath = sRequiredElementParentPath.trim();
            if (sRequiredElementParentPath.startsWith("/")) {
                this.m_listRequiredElementParentNames.add("/");
            }
            StringTokenizer tokenizer = new StringTokenizer(sRequiredElementParentPath, "/");
            while (tokenizer.hasMoreTokens()) {
                this.m_listRequiredElementParentNames.add(tokenizer.nextToken());
            }
            this.m_sRequiredElementName = sRequiredElementName.trim();
        }

        public String getRequiredElementName() {
            return this.m_sRequiredElementName;
        }

        public boolean matches(XmlElement element) {
            boolean fPathMatches = true;
            for (int i = this.m_listRequiredElementParentNames.size() - 1; i >= 0 && fPathMatches; --i) {
                String sParentName = this.m_listRequiredElementParentNames.get(i);
                if (element != null && sParentName.equals("/")) {
                    fPathMatches = element.getParent() == null;
                    continue;
                }
                if (element != null && element.getName().equals(sParentName)) {
                    element = element.getParent();
                    continue;
                }
                fPathMatches = false;
            }
            return fPathMatches;
        }
    }
}

