/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.NamedQueueScheme;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.queue.DefaultNamedQueueDependencies;
import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.NamedQueueDependencies;
import com.tangosol.internal.net.queue.SimpleNamedMapDeque;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedQueue;
import com.tangosol.net.QueueService;
import com.tangosol.net.Service;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.cache.NearCache;

public class SimpleDequeScheme
extends DistributedScheme
implements NamedQueueScheme<NamedMapDeque> {
    public static final SimpleDequeScheme INSTANCE = new SimpleDequeScheme();

    public SimpleDequeScheme() {
        super(new DefaultNamedQueueDependencies());
    }

    @Override
    public String getServiceType() {
        return "DistributedQueue";
    }

    @Override
    public <T extends NamedCollection> boolean realizes(Class<T> type) {
        return type.isAssignableFrom(NamedMapDeque.class);
    }

    @Override
    public SimpleDequeScheme getNamedCollectionBuilder(Class<? extends NamedCollection> clz, Options<NamedCollection.Option> options) {
        if (clz.isAssignableFrom(NamedQueue.class)) {
            return this;
        }
        return null;
    }

    @Override
    public <V> NamedMapDeque realize(ValueTypeAssertion<V> typeConstraint, ParameterResolver resolver, MapBuilder.Dependencies deps) {
        String sQueueName;
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        NamedCache cache = eccf.ensureCache(sQueueName = deps.getCacheName(), null);
        if (cache instanceof NearCache) {
            cache = ((NearCache)cache).getBackCache();
        }
        return new SimpleNamedMapDeque(sQueueName, cache);
    }

    @Override
    public QueueService ensureConfiguredService(ParameterResolver resolver, MapBuilder.Dependencies deps) {
        return this.getOrEnsureService(deps);
    }

    private QueueService getOrEnsureService(MapBuilder.Dependencies deps) {
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        Service service = CacheFactory.getCluster().getService(this.getScopedServiceName());
        if (service == null) {
            service = eccf.ensureService(this);
        }
        if (service instanceof QueueService) {
            return (QueueService)service;
        }
        throw new IllegalArgumentException("Error: the configured service " + service.getInfo().getServiceName() + " is not a QueueService");
    }

    public NamedQueueDependencies createConfiguration(ParameterResolver resolver, ClassLoader loader) {
        return new DefaultNamedQueueDependencies();
    }
}

