/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.Options;
import com.tangosol.application.ContainerContext;
import com.tangosol.coherence.config.builder.NamedCollectionBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.ServiceBuilder;
import com.tangosol.coherence.config.scheme.Scheme;
import com.tangosol.net.NamedCollection;
import java.util.List;

public interface ServiceScheme
extends Scheme {
    public static final String DELIM_DOMAIN_PARTITION = "/";
    public static final String DELIM_APPLICATION_SCOPE = ":";

    public boolean isAutoStart();

    public String getServiceName();

    public String getScopedServiceName();

    default public String getScopedServiceNameForProperty() {
        return this.getScopedServiceName().replace(DELIM_DOMAIN_PARTITION.charAt(0), '.').replace(DELIM_APPLICATION_SCOPE.charAt(0), '.');
    }

    public String getServiceType();

    public ServiceBuilder getServiceBuilder();

    public List<NamedEventInterceptorBuilder> getEventInterceptorBuilders();

    default public NamedCollectionBuilder getNamedCollectionBuilder(Class<? extends NamedCollection> clz, Options<NamedCollection.Option> options) {
        throw new UnsupportedOperationException();
    }

    public static String getScopePrefix(String sScopeName, ContainerContext context) {
        if (sScopeName == null) {
            return null;
        }
        String sTenant = context == null || context.isGlobalDomainPartition() ? null : context.getDomainPartition();
        return sTenant == null || sTenant.trim().length() == 0 ? sScopeName : sTenant + DELIM_DOMAIN_PARTITION + sScopeName;
    }

    public static String getScopedServiceName(String sScopeName, String sServiceName) {
        return sScopeName == null || sScopeName.trim().length() == 0 ? sServiceName : sScopeName + DELIM_APPLICATION_SCOPE + sServiceName;
    }
}

